/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Map;
import org.infinispan.Version;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.marshalling.ClassResolver;

public class SerializationConfiguration {
    public static final AttributeDefinition<Marshaller> MARSHALLER = AttributeDefinition.builder((String)"marshaller", null, Marshaller.class).immutable().build();
    public static final AttributeDefinition<Short> VERSION = AttributeDefinition.builder((String)"version", (Object)Version.getMarshallVersion()).immutable().build();
    public static final AttributeDefinition<ClassResolver> CLASS_RESOLVER = AttributeDefinition.builder((String)"classResolver", null, ClassResolver.class).immutable().build();
    private final Map<Integer, AdvancedExternalizer<?>> advancedExternalizers;
    private final ClassResolver classResolver;
    private final Marshaller marshaller;
    private final short version;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SerializationConfiguration.class, new AttributeDefinition[]{MARSHALLER, VERSION, CLASS_RESOLVER});
    }

    SerializationConfiguration(AttributeSet attributes, Map<Integer, AdvancedExternalizer<?>> advancedExternalizers) {
        this.attributes = attributes.checkProtection();
        this.marshaller = (Marshaller)attributes.attribute(MARSHALLER).get();
        this.version = (Short)attributes.attribute(VERSION).get();
        this.classResolver = (ClassResolver)attributes.attribute(CLASS_RESOLVER).get();
        this.advancedExternalizers = advancedExternalizers;
    }

    public Marshaller marshaller() {
        return this.marshaller;
    }

    public short version() {
        return this.version;
    }

    public Map<Integer, AdvancedExternalizer<?>> advancedExternalizers() {
        return this.advancedExternalizers;
    }

    public ClassResolver classResolver() {
        return this.classResolver;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "SerializationConfiguration [advancedExternalizers=" + this.advancedExternalizers + ", attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.advancedExternalizers == null ? 0 : this.advancedExternalizers.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializationConfiguration other = (SerializationConfiguration)obj;
        if (this.advancedExternalizers == null ? other.advancedExternalizers != null : !this.advancedExternalizers.equals(other.advancedExternalizers)) {
            return false;
        }
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }
}

