/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.service.SecurityActions;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SubjectFactory;
import org.jboss.security.plugins.JBossSecuritySubjectFactory;

public class SubjectFactoryService
implements Service<SubjectFactory> {
    public static final ServiceName SERVICE_NAME = SecurityExtension.JBOSS_SECURITY.append(new String[]{"subject-factory"});
    private final InjectedValue<ISecurityManagement> securityManagementValue = new InjectedValue();
    private SubjectFactory subjectFactory;
    private String subjectFactoryClassName;

    public SubjectFactoryService(String subjectFactoryClassName) {
        this.subjectFactoryClassName = subjectFactoryClassName;
    }

    public synchronized void start(StartContext context) throws StartException {
        SecurityLogger.ROOT_LOGGER.debugf("Starting SubjectFactoryService", new Object[0]);
        ISecurityManagement injectedSecurityManagement = (ISecurityManagement)this.securityManagementValue.getValue();
        int i = this.subjectFactoryClassName.lastIndexOf(":");
        if (i == -1) {
            throw SecurityLogger.ROOT_LOGGER.missingModuleName("subject-factory-class-name attribute");
        }
        String moduleSpec = this.subjectFactoryClassName.substring(0, i);
        String className = this.subjectFactoryClassName.substring(i + 1);
        JBossSecuritySubjectFactory subjectFactory = null;
        try {
            Class subjectFactoryClazz = SecurityActions.getModuleClassLoader(moduleSpec).loadClass(className);
            subjectFactory = (JBossSecuritySubjectFactory)subjectFactoryClazz.newInstance();
        }
        catch (Exception e) {
            throw SecurityLogger.ROOT_LOGGER.unableToStartException("SubjectFactoryService", e);
        }
        subjectFactory.setSecurityManagement(injectedSecurityManagement);
        this.subjectFactory = subjectFactory;
    }

    public synchronized void stop(StopContext context) {
    }

    public synchronized SubjectFactory getValue() throws IllegalStateException {
        return this.subjectFactory;
    }

    public Injector<ISecurityManagement> getSecurityManagementInjector() {
        return this.securityManagementValue;
    }
}

