/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.StreamConnection;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.netty.transport.AbstractXnioServerSocketChannel;
import org.xnio.netty.transport.XnioEventLoop;
import org.xnio.netty.transport.XnioSocketChannelConfig;

abstract class AbstractXnioSocketChannel
extends AbstractChannel
implements SocketChannel {
    private static final ChannelMetadata META_DATA = new ChannelMetadata(false);
    private final XnioSocketChannelConfig config = new XnioSocketChannelConfig(this);
    private Runnable flushTask;
    private ChannelListener<ConduitStreamSinkChannel> writeListener;
    private volatile boolean closed;

    AbstractXnioSocketChannel(AbstractXnioServerSocketChannel parent) {
        super((Channel)parent);
    }

    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    protected abstract AbstractXnioUnsafe newUnsafe();

    protected boolean isCompatible(EventLoop loop) {
        if (!(loop instanceof XnioEventLoop)) {
            return false;
        }
        ServerSocketChannel parent = this.parent();
        return parent == null || parent.eventLoop().parent() == loop.parent();
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    private void incompleteWrite(boolean setOpWrite) {
        if (setOpWrite) {
            this.setOpWrite();
        } else {
            Runnable flushTask = this.flushTask;
            if (flushTask == null) {
                flushTask = this.flushTask = new Runnable(){

                    @Override
                    public void run() {
                        AbstractXnioSocketChannel.this.flush();
                    }
                };
            }
            this.eventLoop().execute(flushTask);
        }
    }

    private void setOpWrite() {
        ConduitStreamSinkChannel sink = this.connection().getSinkChannel();
        if (!sink.isWriteResumed()) {
            WriteListener writeListener = this.writeListener;
            if (writeListener == null) {
                writeListener = this.writeListener = new WriteListener();
            }
            sink.getWriteSetter().set(writeListener);
            sink.resumeWrites();
        }
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        block20: {
            Object msg;
            block21: {
                boolean setOpWrite;
                int writeSpinCount = -1;
                ConduitStreamSinkChannel sink = this.connection().getSinkChannel();
                while (true) {
                    ByteBuffer[] nioBuffers;
                    int msgCount;
                    if ((msgCount = in.size()) > 0 && (nioBuffers = in.nioBuffers()) != null) {
                        int i;
                        int nioBufferCnt = in.nioBufferCount();
                        long expectedWrittenBytes = in.nioBufferSize();
                        long writtenBytes = 0L;
                        boolean done = false;
                        boolean setOpWrite2 = false;
                        for (i = this.config().getWriteSpinCount() - 1; i >= 0; --i) {
                            long localWrittenBytes = sink.write(nioBuffers, 0, nioBufferCnt);
                            if (localWrittenBytes == 0L) {
                                setOpWrite2 = true;
                                break;
                            }
                            writtenBytes += localWrittenBytes;
                            if ((expectedWrittenBytes -= localWrittenBytes) != 0L) continue;
                            done = true;
                            break;
                        }
                        if (done) {
                            for (i = msgCount; i > 0; --i) {
                                in.remove();
                            }
                            if (!in.isEmpty()) continue;
                            this.connection().getSinkChannel().suspendWrites();
                        } else {
                            for (i = msgCount; i > 0; --i) {
                                ByteBuf buf = (ByteBuf)in.current();
                                int readerIndex = buf.readerIndex();
                                int readableBytes = buf.writerIndex() - readerIndex;
                                if ((long)readableBytes < writtenBytes) {
                                    in.progress((long)readableBytes);
                                    in.remove();
                                    writtenBytes -= (long)readableBytes;
                                    continue;
                                }
                                if ((long)readableBytes > writtenBytes) {
                                    buf.readerIndex(readerIndex + (int)writtenBytes);
                                    in.progress(writtenBytes);
                                    break;
                                }
                                in.progress((long)readableBytes);
                                in.remove();
                                break;
                            }
                            this.incompleteWrite(setOpWrite2);
                        }
                        break block20;
                    }
                    msg = in.current();
                    if (msg == null) {
                        this.connection().getSinkChannel().suspendWrites();
                        break block20;
                    }
                    if (msg instanceof ByteBuf) {
                        ByteBuf buf = (ByteBuf)msg;
                        int readableBytes = buf.readableBytes();
                        if (readableBytes == 0) {
                            in.remove();
                            continue;
                        }
                        boolean setOpWrite3 = false;
                        boolean done = false;
                        long flushedAmount = 0L;
                        if (writeSpinCount == -1) {
                            writeSpinCount = this.config().getWriteSpinCount();
                        }
                        for (int i = writeSpinCount - 1; i >= 0; --i) {
                            int localFlushedAmount = buf.readBytes((GatheringByteChannel)sink, buf.readableBytes());
                            if (localFlushedAmount == 0) {
                                setOpWrite3 = true;
                                break;
                            }
                            flushedAmount += (long)localFlushedAmount;
                            if (buf.isReadable()) continue;
                            done = true;
                            break;
                        }
                        in.progress(flushedAmount);
                        if (done) {
                            in.remove();
                            continue;
                        }
                        this.incompleteWrite(setOpWrite3);
                        break block20;
                    }
                    if (!(msg instanceof FileRegion)) break block21;
                    FileRegion region = (FileRegion)msg;
                    setOpWrite = false;
                    boolean done = false;
                    long flushedAmount = 0L;
                    if (writeSpinCount == -1) {
                        writeSpinCount = this.config().getWriteSpinCount();
                    }
                    for (int i = writeSpinCount - 1; i >= 0; --i) {
                        long localFlushedAmount = region.transferTo((WritableByteChannel)sink, region.transfered());
                        if (localFlushedAmount == 0L) {
                            setOpWrite = true;
                            break;
                        }
                        flushedAmount += localFlushedAmount;
                        if (region.transfered() < region.count()) continue;
                        done = true;
                        break;
                    }
                    in.progress(flushedAmount);
                    if (!done) break;
                    in.remove();
                }
                this.incompleteWrite(setOpWrite);
                break block20;
            }
            throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg));
        }
    }

    public SocketChannelConfig config() {
        return this.config;
    }

    public ChannelFuture shutdownOutput() {
        return this.newFailedFuture(new UnsupportedOperationException());
    }

    public ChannelFuture shutdownOutput(ChannelPromise future) {
        return this.newFailedFuture(new UnsupportedOperationException());
    }

    public boolean isOpen() {
        StreamConnection conn = this.connection();
        return (conn == null || conn.isOpen()) && !this.closed;
    }

    public boolean isActive() {
        StreamConnection conn = this.connection();
        return conn != null && conn.isOpen() && !this.closed;
    }

    public ChannelMetadata metadata() {
        return META_DATA;
    }

    protected SocketAddress localAddress0() {
        StreamConnection conn = this.connection();
        if (conn == null) {
            return null;
        }
        return conn.getLocalAddress();
    }

    protected SocketAddress remoteAddress0() {
        StreamConnection conn = this.connection();
        if (conn == null) {
            return null;
        }
        return conn.getPeerAddress();
    }

    public boolean isInputShutdown() {
        StreamConnection conn = this.connection();
        return conn == null || conn.isReadShutdown();
    }

    public boolean isOutputShutdown() {
        StreamConnection conn = this.connection();
        return conn == null || conn.isWriteShutdown();
    }

    protected void doBeginRead() throws Exception {
        StreamConnection conn = this.connection();
        if (conn == null) {
            return;
        }
        ((AbstractXnioUnsafe)this.unsafe()).beginRead0();
        ConduitStreamSourceChannel source = conn.getSourceChannel();
        if (!source.isReadResumed()) {
            source.resumeReads();
        }
    }

    protected void doClose() throws Exception {
        this.closed = true;
        StreamConnection conn = this.connection();
        if (conn != null) {
            AbstractXnioSocketChannel.suspend(conn);
            conn.close();
        }
    }

    <T> T getOption(Option<T> option) {
        try {
            return this.getOption0(option);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    <T> void setOption(Option<T> option, T value) {
        try {
            this.setOption0(option, value);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private static void suspend(StreamConnection connection) {
        if (connection == null) {
            return;
        }
        connection.getSourceChannel().suspendReads();
        connection.getSinkChannel().suspendWrites();
    }

    protected abstract <T> void setOption0(Option<T> var1, T var2) throws IOException;

    protected abstract <T> T getOption0(Option<T> var1) throws IOException;

    protected abstract StreamConnection connection();

    public boolean isShutdown() {
        return this.isInputShutdown() && this.isOutputShutdown();
    }

    public ChannelFuture shutdown() {
        ChannelFuture inputFuture = this.shutdownInput();
        ChannelFuture outputFuture = this.shutdownOutput();
        return this.getShutdownChannelFuture(inputFuture, outputFuture);
    }

    public ChannelFuture shutdown(ChannelPromise channelPromise) {
        ChannelFuture inputFuture = this.shutdownInput(channelPromise);
        ChannelFuture outputFuture = this.shutdownOutput(channelPromise);
        return this.getShutdownChannelFuture(inputFuture, outputFuture);
    }

    private ChannelFuture getShutdownChannelFuture(final ChannelFuture inputFuture, final ChannelFuture outputFuture) {
        return new ChannelFuture(){

            public boolean isSuccess() {
                return inputFuture.isSuccess() && outputFuture.isSuccess();
            }

            public boolean isCancellable() {
                return inputFuture.isCancellable() && outputFuture.isCancellable();
            }

            public Throwable cause() {
                return inputFuture.cause() != null ? inputFuture.cause() : outputFuture.cause();
            }

            public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
                long currentTimeMillis = System.currentTimeMillis();
                if (inputFuture.await(timeout, unit)) {
                    if ((currentTimeMillis -= System.currentTimeMillis()) <= 0L) {
                        return outputFuture.isDone();
                    }
                    return outputFuture.await(currentTimeMillis, TimeUnit.MILLISECONDS);
                }
                return false;
            }

            public boolean await(long timeoutMillis) throws InterruptedException {
                return this.await(timeoutMillis, TimeUnit.MILLISECONDS);
            }

            public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
                long currentTimeMillis = System.currentTimeMillis();
                if (inputFuture.awaitUninterruptibly(timeout, unit)) {
                    if ((currentTimeMillis -= System.currentTimeMillis()) <= 0L) {
                        return outputFuture.isDone();
                    }
                    return outputFuture.awaitUninterruptibly(currentTimeMillis, TimeUnit.MILLISECONDS);
                }
                return false;
            }

            public boolean awaitUninterruptibly(long timeoutMillis) {
                return this.awaitUninterruptibly(timeoutMillis, TimeUnit.MILLISECONDS);
            }

            public Void getNow() {
                return inputFuture.isDone() && outputFuture.isDone() ? (Void)inputFuture.getNow() : null;
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean cancelInput = inputFuture.cancel(mayInterruptIfRunning);
                boolean cancelOutput = outputFuture.cancel(mayInterruptIfRunning);
                return cancelInput && cancelOutput;
            }

            public boolean isCancelled() {
                return inputFuture.isCancelled() && outputFuture.isCancelled();
            }

            public boolean isDone() {
                return inputFuture.isDone() && outputFuture.isDone();
            }

            public Void get() throws InterruptedException, ExecutionException {
                Void inputResult = (Void)inputFuture.get();
                outputFuture.get();
                return inputResult;
            }

            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                Void inputResult = (Void)inputFuture.get(timeout, unit);
                outputFuture.get(timeout, unit);
                return inputResult;
            }

            public Channel channel() {
                return AbstractXnioSocketChannel.this;
            }

            public ChannelFuture addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
                inputFuture.addListener(listener);
                outputFuture.addListener(listener);
                return this;
            }

            public ChannelFuture addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
                inputFuture.addListeners(listeners);
                outputFuture.addListeners(listeners);
                return this;
            }

            public ChannelFuture removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
                inputFuture.removeListener(listener);
                outputFuture.removeListener(listener);
                return this;
            }

            public ChannelFuture removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
                inputFuture.removeListeners(listeners);
                outputFuture.removeListeners(listeners);
                return this;
            }

            public ChannelFuture sync() throws InterruptedException {
                inputFuture.sync();
                outputFuture.sync();
                return this;
            }

            public ChannelFuture syncUninterruptibly() {
                inputFuture.syncUninterruptibly();
                outputFuture.syncUninterruptibly();
                return this;
            }

            public ChannelFuture await() throws InterruptedException {
                inputFuture.await();
                outputFuture.await();
                return this;
            }

            public ChannelFuture awaitUninterruptibly() {
                inputFuture.awaitUninterruptibly();
                outputFuture.awaitUninterruptibly();
                return this;
            }

            public boolean isVoid() {
                return inputFuture.isVoid() || outputFuture.isVoid();
            }
        };
    }

    private class WriteListener
    implements ChannelListener<ConduitStreamSinkChannel> {
        private WriteListener() {
        }

        public void handleEvent(ConduitStreamSinkChannel channel) {
            ((AbstractXnioUnsafe)AbstractXnioSocketChannel.this.unsafe()).forceFlush();
        }
    }

    final class ReadListener
    implements ChannelListener<ConduitStreamSourceChannel> {
        private RecvByteBufAllocator.Handle allocHandle;

        ReadListener() {
        }

        private void removeReadOp(ConduitStreamSourceChannel channel) {
            if (channel.isReadResumed()) {
                channel.suspendReads();
            }
        }

        private void closeOnRead() {
            StreamConnection connection = AbstractXnioSocketChannel.this.connection();
            AbstractXnioSocketChannel.suspend(connection);
            if (AbstractXnioSocketChannel.this.isOpen()) {
                AbstractXnioSocketChannel.this.unsafe().close(AbstractXnioSocketChannel.this.unsafe().voidPromise());
            }
        }

        private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    pipeline.fireChannelRead((Object)byteBuf);
                } else {
                    try {
                        byteBuf.release();
                    }
                    catch (IllegalReferenceCountException illegalReferenceCountException) {
                        // empty catch block
                    }
                }
            }
            pipeline.fireChannelReadComplete();
            pipeline.fireExceptionCaught(cause);
            if (close || cause instanceof IOException) {
                this.closeOnRead();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConduitStreamSourceChannel channel) {
            SocketChannelConfig config = AbstractXnioSocketChannel.this.config();
            ChannelPipeline pipeline = AbstractXnioSocketChannel.this.pipeline();
            ByteBufAllocator allocator = config.getAllocator();
            int maxMessagesPerRead = config.getMaxMessagesPerRead();
            RecvByteBufAllocator.Handle allocHandle = this.allocHandle;
            if (allocHandle == null) {
                this.allocHandle = allocHandle = config.getRecvByteBufAllocator().newHandle();
            }
            ByteBuf byteBuf = null;
            int messages = 0;
            boolean close = false;
            try {
                int writable;
                int localReadAmount;
                int byteBufCapacity = allocHandle.guess();
                int totalReadAmount = 0;
                do {
                    byteBuf = allocator.ioBuffer(byteBufCapacity);
                    writable = byteBuf.writableBytes();
                    localReadAmount = byteBuf.writeBytes((ScatteringByteChannel)channel, byteBuf.writableBytes());
                    if (localReadAmount <= 0) {
                        byteBuf.release();
                        close = localReadAmount < 0;
                        break;
                    }
                    ((AbstractXnioUnsafe)AbstractXnioSocketChannel.this.unsafe()).readPending = false;
                    pipeline.fireChannelRead((Object)byteBuf);
                    byteBuf = null;
                    if (totalReadAmount >= Integer.MAX_VALUE - localReadAmount) {
                        totalReadAmount = Integer.MAX_VALUE;
                        break;
                    }
                    totalReadAmount += localReadAmount;
                } while (config.isAutoRead() && localReadAmount >= writable && ++messages < maxMessagesPerRead && allocHandle.continueReading());
                allocHandle.incMessagesRead(messages);
                allocHandle.lastBytesRead(totalReadAmount);
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                if (close) {
                    this.closeOnRead();
                    close = false;
                }
            }
            catch (Throwable t) {
                this.handleReadException(pipeline, byteBuf, t, close);
            }
            finally {
                if (!config.isAutoRead() && !((AbstractXnioUnsafe)AbstractXnioSocketChannel.this.unsafe()).readPending) {
                    this.removeReadOp(channel);
                }
            }
        }
    }

    protected abstract class AbstractXnioUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private boolean readPending;

        protected AbstractXnioUnsafe() {
            super((AbstractChannel)AbstractXnioSocketChannel.this);
            this.readPending = false;
        }

        public void beginRead0() {
            this.readPending = true;
        }

        protected void flush0() {
            if (AbstractXnioSocketChannel.this.connection().getSinkChannel().isWriteResumed()) {
                return;
            }
            super.flush0();
        }

        public void forceFlush() {
            super.flush0();
        }
    }
}

