/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.LegacyPropertiesSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

class PropertiesRealmDefinition {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", FileAttributeDefinitions.PATH).setRequired(true)).build();
    private static final SimpleAttributeDefinition PLAIN_TEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("plain-text", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static final SimpleAttributeDefinition DIGEST_REALM_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("digest-realm-name", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final ObjectTypeAttributeDefinition USERS_PROPERTIES = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("users-properties", new AttributeDefinition[]{PATH, FileAttributeDefinitions.RELATIVE_TO, DIGEST_REALM_NAME, PLAIN_TEXT}).setRequired(true)).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition GROUPS_PROPERTIES = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("groups-properties", new AttributeDefinition[]{PATH, FileAttributeDefinitions.RELATIVE_TO}).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition GROUPS_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("groups-attribute", ModelType.STRING, true).setDefaultValue(new ModelNode("groups"))).setAllowExpression(true)).setRestartAllServices()).build();
    private static final SimpleAttributeDefinition SYNCHRONIZED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("synchronized", ModelType.STRING).setStorageRuntime()).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{USERS_PROPERTIES, GROUPS_PROPERTIES, GROUPS_ATTRIBUTE};
    private static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("properties-realm");
    private static final SimpleOperationDefinition LOAD = new SimpleOperationDefinitionBuilder("load", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setRuntimeOnly().build();
    private static final AbstractAddStepHandler ADD = new TrivialAddHandler<SecurityRealm>(SecurityRealm.class, ATTRIBUTES, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY){

        @Override
        protected TrivialService.ValueSupplier<SecurityRealm> getValueSupplier(ServiceBuilder<SecurityRealm> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
            String groupsRelativeTo;
            String groupsPath;
            final String groupsAttribute = GROUPS_ATTRIBUTE.resolveModelAttribute(context, model).asString();
            ModelNode usersProperties = USERS_PROPERTIES.resolveModelAttribute(context, model);
            final String usersPath = PATH.resolveModelAttribute(context, usersProperties).asStringOrNull();
            final String usersRelativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, usersProperties).asStringOrNull();
            final String digestRealmName = DIGEST_REALM_NAME.resolveModelAttribute(context, usersProperties).asStringOrNull();
            final boolean plainText = PLAIN_TEXT.resolveModelAttribute(context, usersProperties).asBoolean();
            ModelNode groupsProperties = GROUPS_PROPERTIES.resolveModelAttribute(context, model);
            if (groupsProperties.isDefined()) {
                groupsPath = PATH.resolveModelAttribute(context, groupsProperties).asStringOrNull();
                groupsRelativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, groupsProperties).asStringOrNull();
            } else {
                groupsPath = null;
                groupsRelativeTo = null;
            }
            final InjectedValue pathManagerInjector = new InjectedValue();
            if (usersRelativeTo != null || groupsRelativeTo != null) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManagerInjector);
                if (usersRelativeTo != null) {
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(usersRelativeTo));
                }
                if (groupsRelativeTo != null) {
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(groupsRelativeTo));
                }
            }
            return new TrivialService.ValueSupplier<SecurityRealm>(){
                private final List<PathManager.Callback.Handle> callbackHandles = new ArrayList<PathManager.Callback.Handle>();

                /*
                 * Exception decompiling
                 */
                @Override
                public SecurityRealm get() throws StartException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                public void dispose() {
                    for (PathManager.Callback.Handle h : this.callbackHandles) {
                        h.remove();
                    }
                }

                private File resolveFileLocation(String path, String relativeTo) {
                    File resolvedPath;
                    if (relativeTo != null) {
                        PathManager pathManager = (PathManager)pathManagerInjector.getValue();
                        resolvedPath = new File(pathManager.resolveRelativePathEntry(path, relativeTo));
                        PathManager.Callback.Handle callbackHandle = pathManager.registerCallback(relativeTo, new PathManager.Callback(){

                            public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                                if (!eventContext.isResourceServiceRestartAllowed()) {
                                    eventContext.reloadRequired();
                                }
                            }

                            public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                            }
                        }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
                        this.callbackHandles.add(callbackHandle);
                    } else {
                        resolvedPath = new File(path);
                    }
                    return resolvedPath;
                }
            };
        }
    };

    PropertiesRealmDefinition() {
    }

    static ResourceDefinition create(boolean serverOrHostController) {
        TrivialResourceDefinition.Builder builder = TrivialResourceDefinition.builder().setPathKey("properties-realm").setResourceDescriptionResolver((ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler(ADD).setAttributes(ATTRIBUTES).setRuntimeCapabilities(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
        if (serverOrHostController) {
            builder.addReadOnlyAttribute((AttributeDefinition)SYNCHRONIZED, new PropertiesRuntimeHandler(false){

                @Override
                void performRuntime(OperationContext context, RealmWrapper securityRealm) throws OperationFailedException {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                    context.getResult().set(sdf.format(new Date(securityRealm.getLoadTime())));
                }
            });
        }
        builder.addOperation((OperationDefinition)LOAD, new PropertiesRuntimeHandler(true){

            @Override
            void performRuntime(OperationContext context, RealmWrapper securityRealm) throws OperationFailedException {
                securityRealm.reload();
            }
        });
        return builder.build();
    }

    private static final class RealmWrapper
    implements SecurityRealm {
        private final LegacyPropertiesSecurityRealm delegate;
        private final File usersFile;
        private final File groupsFile;

        RealmWrapper(LegacyPropertiesSecurityRealm delegate, File usersFile, File groupsFile) {
            this.delegate = delegate;
            this.usersFile = usersFile;
            this.groupsFile = groupsFile;
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            return this.delegate.getRealmIdentity(principal);
        }

        public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
            return this.delegate.getRealmIdentity(evidence);
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.delegate.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.delegate.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.delegate.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        public void handleRealmEvent(RealmEvent event) {
            this.delegate.handleRealmEvent(event);
        }

        long getLoadTime() {
            return this.delegate.getLoadTime();
        }

        void reload() throws OperationFailedException {
            try (FileInputStream usersInputStream = new FileInputStream(this.usersFile);
                 FileInputStream groupsInputStream = this.groupsFile != null ? new FileInputStream(this.groupsFile) : null;){
                this.delegate.load((InputStream)usersInputStream, (InputStream)groupsInputStream);
            }
            catch (IOException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToReLoadPropertiesFiles(e);
            }
        }
    }

    static abstract class PropertiesRuntimeHandler
    extends ElytronRuntimeOnlyHandler {
        private final boolean writeAccess;

        PropertiesRuntimeHandler(boolean writeAccess) {
            this.writeAccess = writeAccess;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName securityRealmName = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue()).getCapabilityServiceName();
            ServiceController<SecurityRealm> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(this.writeAccess), securityRealmName, SecurityRealm.class);
            ServiceController.State serviceState = serviceContainer.getState();
            if (serviceState != ServiceController.State.UP) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(securityRealmName, serviceState);
            }
            SecurityRealm securityRealm = (SecurityRealm)serviceContainer.getValue();
            assert (securityRealm instanceof RealmWrapper);
            this.performRuntime(context, (RealmWrapper)securityRealm);
        }

        abstract void performRuntime(OperationContext var1, RealmWrapper var2) throws OperationFailedException;
    }
}

