/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.pool.ConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public final class ConnectionHandler {
    private static final AtomicReferenceFieldUpdater<ConnectionHandler, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(ConnectionHandler.class, State.class, "state");
    private final Connection connection;
    private final XAResource xaResource;
    private final ConnectionPool connectionPool;
    private final Set<DirtyAttribute> dirtyAttributes = EnumSet.noneOf(DirtyAttribute.class);
    private volatile State state;
    private Thread holdingThread;
    private long lastAccess;
    private boolean enlisted;

    public ConnectionHandler(XAConnection xaConnection, ConnectionPool pool) throws SQLException {
        this.connection = xaConnection.getConnection();
        this.xaResource = xaConnection.getXAResource();
        this.connectionPool = pool;
        this.state = State.NEW;
        this.lastAccess = System.nanoTime();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public XAResource getXaResource() {
        return this.xaResource;
    }

    public void returnConnection() throws SQLException {
        this.connectionPool.returnConnection(this);
    }

    public void resetConnection(AgroalConnectionFactoryConfiguration connectionFactoryConfiguration) throws SQLException {
        if (!this.dirtyAttributes.isEmpty()) {
            if (this.dirtyAttributes.contains((Object)DirtyAttribute.AUTOCOMMIT)) {
                this.connection.setAutoCommit(connectionFactoryConfiguration.autoCommit());
            }
            if (this.dirtyAttributes.contains((Object)DirtyAttribute.TRANSACTION_ISOLATION)) {
                this.connection.setTransactionIsolation(connectionFactoryConfiguration.jdbcTransactionIsolation().level());
            }
            this.dirtyAttributes.clear();
        }
    }

    public void closeConnection() throws SQLException {
        try {
            if (this.state != State.FLUSH) {
                throw new SQLException("Closing connection in incorrect state " + (Object)((Object)this.state));
            }
        }
        finally {
            this.connection.close();
        }
    }

    public boolean setState(State expected, State newState) {
        if (expected == State.DESTROYED) {
            throw new IllegalArgumentException("Trying to move out of state DESTROYED");
        }
        switch (newState) {
            case NEW: {
                throw new IllegalArgumentException("Trying to set invalid state NEW");
            }
            case CHECKED_IN: 
            case CHECKED_OUT: 
            case VALIDATION: 
            case FLUSH: 
            case DESTROYED: {
                return stateUpdater.compareAndSet(this, expected, newState);
            }
        }
        throw new IllegalArgumentException("Trying to set invalid state " + (Object)((Object)newState));
    }

    public void setState(State newState) {
        stateUpdater.set(this, newState);
    }

    public boolean isActive() {
        return stateUpdater.get(this) == State.CHECKED_OUT;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public Thread getHoldingThread() {
        return this.holdingThread;
    }

    public void setHoldingThread(Thread holdingThread) {
        this.holdingThread = holdingThread;
    }

    public void setDirtyAttribute(DirtyAttribute attribute) {
        this.dirtyAttributes.add(attribute);
    }

    public boolean isEnlisted() {
        return this.enlisted;
    }

    public void setEnlisted() {
        this.enlisted = true;
    }

    public void resetEnlisted() {
        this.enlisted = false;
    }

    public static enum DirtyAttribute {
        AUTOCOMMIT,
        TRANSACTION_ISOLATION,
        NETWORK_TIMEOUT,
        SCHEMA,
        CATALOG;

    }

    public static enum State {
        NEW,
        CHECKED_IN,
        CHECKED_OUT,
        VALIDATION,
        FLUSH,
        DESTROYED;

    }
}

