/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.access.InvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.access.SessionInvocationContext;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class NonTxInvalidationCacheAccessDelegate
extends InvalidationCacheAccessDelegate {
    private final AsyncInterceptorChain invoker;
    private final CommandsFactory commandsFactory;
    private final Metadata metadata;
    private final KeyPartitioner keyPartitioner;

    public NonTxInvalidationCacheAccessDelegate(InfinispanDataRegion region, PutFromLoadValidator validator) {
        super(region, validator);
        ComponentRegistry cr = region.getCache().getComponentRegistry();
        this.invoker = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
        this.commandsFactory = (CommandsFactory)cr.getComponent(CommandsFactory.class);
        this.keyPartitioner = (KeyPartitioner)cr.getComponent(KeyPartitioner.class);
        Configuration config = region.getCache().getCacheConfiguration();
        this.metadata = new EmbeddedMetadata.Builder().lifespan(config.expiration().lifespan()).maxIdle(config.expiration().maxIdle()).build();
    }

    @Override
    public boolean insert(Object session, Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, this.keyPartitioner.getSegment(key), this.metadata, FlagBitSets.IGNORE_RETURN_VALUES);
        SessionInvocationContext ctx = new SessionInvocationContext(session, command.getKeyLockOwner());
        this.invoker.invoke((InvocationContext)ctx, (VisitableCommand)command);
        return true;
    }

    @Override
    public boolean update(Object session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, this.keyPartitioner.getSegment(key), this.metadata, FlagBitSets.IGNORE_RETURN_VALUES);
        SessionInvocationContext ctx = new SessionInvocationContext(session, command.getKeyLockOwner());
        this.invoker.invoke((InvocationContext)ctx, (VisitableCommand)command);
        return true;
    }

    @Override
    public void remove(Object session, Object key) throws CacheException {
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null, this.keyPartitioner.getSegment(key), FlagBitSets.IGNORE_RETURN_VALUES);
        SessionInvocationContext ctx = new SessionInvocationContext(session, command.getKeyLockOwner());
        this.invoker.invoke((InvocationContext)ctx, (VisitableCommand)command);
    }

    @Override
    public boolean afterInsert(Object session, Object key, Object value, Object version) {
        return false;
    }

    @Override
    public boolean afterUpdate(Object session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        return false;
    }

    @Override
    public void removeAll() throws CacheException {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                log.failedInvalidateRegion(this.region.getName());
            }
            this.cache.clear();
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }
}

