/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import java.io.InputStream;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.config.IDPMetadataConfigurationProvider;
import org.picketlink.identity.federation.web.config.SPPostMetadataConfigurationProvider;
import org.picketlink.identity.federation.web.config.SPRedirectMetadataConfigurationProvider;
import org.wildfly.extension.picketlink.federation.config.IDPConfiguration;
import org.wildfly.extension.picketlink.federation.config.SPConfiguration;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class DomainModelConfigProvider
extends AbstractSAMLConfigurationProvider {
    private final PicketLinkType configuration;

    public DomainModelConfigProvider(PicketLinkType picketLinkType) {
        this.configuration = picketLinkType;
    }

    public IDPType getIDPConfiguration() {
        ProviderType providerType = this.getPicketLinkConfiguration().getIdpOrSP();
        if (providerType instanceof IDPConfiguration) {
            IDPConfiguration configuration = (IDPConfiguration)providerType;
            if (configuration.isSupportMetadata()) {
                try {
                    IDPType metadataConfig = new IDPMetadataConfigurationProvider().getIDPConfiguration();
                    metadataConfig.importFrom((IDPType)configuration);
                    providerType = metadataConfig;
                }
                catch (ProcessingException e) {
                    throw PicketLinkLogger.ROOT_LOGGER.federationSAMLMetadataConfigError(configuration.getAlias(), e);
                }
            }
            if (this.configParsedIDPType != null) {
                configuration.importFrom(this.configParsedIDPType);
            }
            return (IDPType)providerType;
        }
        return null;
    }

    public SPType getSPConfiguration() {
        ProviderType providerType = this.getPicketLinkConfiguration().getIdpOrSP();
        if (providerType instanceof SPConfiguration) {
            SPConfiguration configuration = (SPConfiguration)providerType;
            if (configuration.isSupportMetadata()) {
                try {
                    SPType metadataConfig = configuration.isPostBinding() ? new SPPostMetadataConfigurationProvider().getSPConfiguration() : new SPRedirectMetadataConfigurationProvider().getSPConfiguration();
                    metadataConfig.importFrom((ProviderType)configuration);
                    providerType = metadataConfig;
                }
                catch (ProcessingException e) {
                    throw PicketLinkLogger.ROOT_LOGGER.federationSAMLMetadataConfigError(configuration.getAlias(), e);
                }
            }
            if (this.configParsedSPType != null) {
                configuration.importFrom((ProviderType)this.configParsedSPType);
            }
            return (SPType)providerType;
        }
        return null;
    }

    public PicketLinkType getPicketLinkConfiguration() {
        if (this.configParsedPicketLinkType != null) {
            if (this.configParsedPicketLinkType.getHandlers() != null) {
                this.configuration.setHandlers(this.configParsedPicketLinkType.getHandlers());
            }
            if (this.configParsedPicketLinkType.getStsType() != null) {
                this.configuration.setStsType(this.configParsedPicketLinkType.getStsType());
            }
        }
        return this.configuration;
    }

    public void setConsolidatedConfigFile(InputStream is) throws ParsingException {
        try {
            super.setConsolidatedConfigFile(is);
        }
        catch (Exception e) {
            logger.trace("Configurations defined in picketlink.xml will be ignored.");
        }
    }

    boolean isIdentityProviderConfiguration() {
        return IDPConfiguration.class.isInstance(this.configuration.getIdpOrSP());
    }
}

