/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor.secondLevelCache;

import java.util.HashMap;
import java.util.Properties;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.secondLevelCache.InfinispanCacheDeploymentListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.cache.spi.Wrapper;
import org.jipijapa.event.spi.EventListener;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class CacheDeploymentListener
implements EventListener {
    private static final ThreadLocal<DeploymentSupport> DEPLOYMENT_SUPPORT = new ThreadLocal();
    HashMap<String, EventListener> delegates = new HashMap();

    public CacheDeploymentListener() {
        this.delegates.put(Classification.INFINISPAN.getLocalName(), new InfinispanCacheDeploymentListener());
    }

    public static void setInternalDeploymentSupport(final ServiceBuilder<?> serviceBuilder, final CapabilityServiceSupport support) {
        DEPLOYMENT_SUPPORT.set(new DeploymentSupport(){

            @Override
            public ServiceBuilder<?> getServiceBuilder() {
                return serviceBuilder;
            }

            @Override
            public CapabilityServiceSupport getCapabilityServiceSupport() {
                return support;
            }
        });
    }

    public static void clearInternalDeploymentSupport() {
        DEPLOYMENT_SUPPORT.remove();
    }

    public static ServiceBuilder<?> getInternalDeploymentServiceBuilder() {
        return DEPLOYMENT_SUPPORT.get().getServiceBuilder();
    }

    public static CapabilityServiceSupport getInternalDeploymentCapablityServiceSupport() {
        return DEPLOYMENT_SUPPORT.get().getCapabilityServiceSupport();
    }

    public void beforeEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
        this.delegates.get(classification.getLocalName()).beforeEntityManagerFactoryCreate(classification, persistenceUnitMetadata);
    }

    public void afterEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
        DEPLOYMENT_SUPPORT.remove();
        this.delegates.get(classification.getLocalName()).afterEntityManagerFactoryCreate(classification, persistenceUnitMetadata);
    }

    public Wrapper startCache(Classification classification, Properties properties) throws Exception {
        if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
            JpaLogger.ROOT_LOGGER.tracef("start second level cache with properties '%s'", properties.toString());
        }
        return this.delegates.get(classification.getLocalName()).startCache(classification, properties);
    }

    public void addCacheDependencies(Classification classification, Properties properties) {
        if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
            JpaLogger.ROOT_LOGGER.tracef("add second level cache dependencies with properties '%s'", properties.toString());
        }
        this.delegates.get(classification.getLocalName()).addCacheDependencies(classification, properties);
    }

    public void stopCache(Classification classification, Wrapper wrapper) {
        this.delegates.get(classification.getLocalName()).stopCache(classification, wrapper);
    }

    private static interface DeploymentSupport {
        public ServiceBuilder<?> getServiceBuilder();

        public CapabilityServiceSupport getCapabilityServiceSupport();
    }
}

