/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.serializer.AbstractContainerSerializer;
import org.eclipse.yasson.internal.serializer.ContainerModel;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class MapSerializer<T extends Map<?, ?>>
extends AbstractContainerSerializer<T>
implements EmbeddedItem {
    private final JsonBindingModel containerModel;

    protected MapSerializer(SerializerBuilder builder) {
        super(builder);
        Class<Object> mapValueRuntimeType = this.getRuntimeType() instanceof ParameterizedType ? ReflectionUtils.resolveType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[1]) : Object.class;
        this.containerModel = new ContainerModel((Type)((Object)mapValueRuntimeType), this.resolveContainerModelCustomization((Type)((Object)mapValueRuntimeType), builder.getJsonbContext()));
    }

    @Override
    protected void serializeInternal(T obj, JsonGenerator generator, SerializationContext ctx) {
        for (Map.Entry entry : obj.entrySet()) {
            String keysString = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            if (value == null) {
                generator.writeNull(keysString);
                return;
            }
            generator.writeKey(keysString);
            this.serializeItem(value, generator, ctx, this.containerModel);
        }
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        generator.writeStartObject();
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        generator.writeStartObject(key);
    }
}

