/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.BackupSender;

public class XSiteAdminCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 32;
    private String siteName;
    private Integer afterFailures;
    private Long minTimeToWait;
    private AdminOperation adminOperation;
    private BackupSender backupSender;

    public XSiteAdminCommand() {
        super(null);
    }

    public XSiteAdminCommand(ByteString cacheName) {
        super(cacheName);
    }

    public XSiteAdminCommand(ByteString cacheName, String siteName, AdminOperation op, Integer afterFailures, Long minTimeToWait) {
        this(cacheName);
        this.siteName = siteName;
        this.adminOperation = op;
        this.afterFailures = afterFailures;
        this.minTimeToWait = minTimeToWait;
    }

    public void init(BackupSender backupSender) {
        this.backupSender = backupSender;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        switch (this.adminOperation) {
            case SITE_STATUS: {
                if (this.backupSender.getOfflineStatus(this.siteName).isOffline()) {
                    return CompletableFuture.completedFuture(Status.OFFLINE);
                }
                return CompletableFuture.completedFuture(Status.ONLINE);
            }
            case STATUS: {
                return CompletableFuture.completedFuture(this.backupSender.status());
            }
            case TAKE_OFFLINE: {
                return CompletableFuture.completedFuture(this.backupSender.takeSiteOffline(this.siteName));
            }
            case BRING_ONLINE: {
                return CompletableFuture.completedFuture(this.backupSender.bringSiteOnline(this.siteName));
            }
            case AMEND_TAKE_OFFLINE: {
                this.backupSender.getOfflineStatus(this.siteName).amend(this.afterFailures, this.minTimeToWait);
                return CompletableFutures.completedNull();
            }
        }
        throw new IllegalStateException("Unhandled admin operation " + (Object)((Object)this.adminOperation));
    }

    @Override
    public byte getCommandId() {
        return 32;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallEnum((Enum)this.adminOperation, (ObjectOutput)output);
        switch (this.adminOperation) {
            case SITE_STATUS: 
            case TAKE_OFFLINE: 
            case BRING_ONLINE: {
                output.writeUTF(this.siteName);
                return;
            }
            case AMEND_TAKE_OFFLINE: {
                output.writeUTF(this.siteName);
                output.writeObject(this.afterFailures);
                output.writeObject(this.minTimeToWait);
                return;
            }
            case STATUS: {
                return;
            }
        }
        throw new IllegalStateException("Unknown admin operation " + (Object)((Object)this.adminOperation));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.adminOperation = (AdminOperation)Objects.requireNonNull(MarshallUtil.unmarshallEnum((ObjectInput)input, x$0 -> AdminOperation.valueOf(x$0)));
        switch (this.adminOperation) {
            case SITE_STATUS: 
            case TAKE_OFFLINE: 
            case BRING_ONLINE: {
                this.siteName = input.readUTF();
                return;
            }
            case AMEND_TAKE_OFFLINE: {
                this.siteName = input.readUTF();
                this.afterFailures = (Integer)input.readObject();
                this.minTimeToWait = (Long)input.readObject();
                return;
            }
            case STATUS: {
                return;
            }
        }
        throw new IllegalStateException("Unknown admin operation " + (Object)((Object)this.adminOperation));
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "XSiteAdminCommand{siteName='" + this.siteName + '\'' + ", afterFailures=" + this.afterFailures + ", minTimeToWait=" + this.minTimeToWait + ", adminOperation=" + (Object)((Object)this.adminOperation) + ", backupSender=" + this.backupSender + '}';
    }

    public static enum Status {
        OFFLINE,
        ONLINE;

    }

    public static enum AdminOperation {
        SITE_STATUS,
        STATUS,
        TAKE_OFFLINE,
        BRING_ONLINE,
        AMEND_TAKE_OFFLINE;

        private static final AdminOperation[] CACHED_VALUES;

        private static AdminOperation valueOf(int index) {
            return CACHED_VALUES[index];
        }

        static {
            CACHED_VALUES = AdminOperation.values();
        }
    }
}

