/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.util.RangeSet;
import org.jboss.marshalling.util.IdentityIntMap;

public class IntSetExternalizer
extends AbstractExternalizer<IntSet> {
    private static final int RANGESET = 0;
    private static final int SMALLINTSET = 1;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(2);

    public IntSetExternalizer() {
        this.numbers.put(RangeSet.class, 0);
        this.numbers.put(org.infinispan.commons.util.RangeSet.class, 0);
        this.numbers.put(SmallIntSet.class, 1);
    }

    public Integer getId() {
        return 132;
    }

    public Set<Class<? extends IntSet>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{SmallIntSet.class, RangeSet.class, org.infinispan.commons.util.RangeSet.class});
    }

    public void writeObject(ObjectOutput output, IntSet object) throws IOException {
        int number = this.numbers.get(object.getClass(), -1);
        output.write(number);
        switch (number) {
            case 0: {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)object.size());
                break;
            }
            case 1: {
                SmallIntSet.writeTo((ObjectOutput)output, (SmallIntSet)((SmallIntSet)object));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported number: " + number);
            }
        }
    }

    public IntSet readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        switch (magicNumber) {
            case 0: {
                return new org.infinispan.commons.util.RangeSet(UnsignedNumeric.readUnsignedInt((ObjectInput)input));
            }
            case 1: {
                return SmallIntSet.readFrom((ObjectInput)input);
            }
        }
        throw new UnsupportedOperationException("Unsupported number: " + magicNumber);
    }
}

