/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class NotifyHelper {
    public static void entryCommitted(CacheNotifier notifier, FunctionalNotifier functionalNotifier, boolean created, boolean removed, boolean expired, CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Object previousValue, Metadata previousMetadata) {
        boolean isWriteOnly;
        if (FlagBitSets.extractStateTransferFlag(ctx, command) != null) {
            return;
        }
        boolean bl = isWriteOnly = command instanceof WriteCommand && ((WriteCommand)command).isWriteOnly();
        if (removed) {
            if (command instanceof RemoveCommand) {
                ((RemoveCommand)command).notify(ctx, previousValue, previousMetadata, false);
            } else if (command instanceof InvalidateCommand) {
                notifier.notifyCacheEntryInvalidated(entry.getKey(), entry.getValue(), entry.getMetadata(), false, ctx, command);
            } else {
                if (expired) {
                    notifier.notifyCacheEntryExpired(entry.getKey(), previousValue, previousMetadata, ctx);
                } else {
                    notifier.notifyCacheEntryRemoved(entry.getKey(), previousValue, previousMetadata, false, ctx, command);
                }
                if (!isWriteOnly) {
                    functionalNotifier.notifyOnRemove(EntryViews.readOnly(entry.getKey(), previousValue, previousMetadata));
                }
                functionalNotifier.notifyOnWrite(() -> EntryViews.noValue(entry.getKey()));
            }
        } else if (created) {
            notifier.notifyCacheEntryCreated(entry.getKey(), entry.getValue(), entry.getMetadata(), false, ctx, command);
            if (!isWriteOnly) {
                functionalNotifier.notifyOnCreate(EntryViews.readOnly(entry));
            }
            functionalNotifier.notifyOnWrite(() -> EntryViews.readOnly(entry));
        } else {
            notifier.notifyCacheEntryModified(entry.getKey(), entry.getValue(), entry.getMetadata(), previousValue, previousMetadata, false, ctx, command);
            if (!isWriteOnly) {
                functionalNotifier.notifyOnModify(EntryViews.readOnly(entry.getKey(), previousValue, previousMetadata), EntryViews.readOnly(entry));
            }
            functionalNotifier.notifyOnWrite(() -> EntryViews.readOnly(entry));
        }
    }
}

