/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.ConcurrentHashSet;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.globalstate.impl.VolatileLocalConfigurationStorage;

public class OverlayLocalConfigurationStorage
extends VolatileLocalConfigurationStorage {
    private ConcurrentHashSet<String> persistentCaches = new ConcurrentHashSet();

    @Override
    public void validateFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (flags.contains(CacheContainerAdmin.AdminFlag.PERMANENT) && !this.globalConfiguration.globalState().enabled()) {
            throw log.globalStateDisabled();
        }
    }

    @Override
    public void createCache(String name, String template, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        super.createCache(name, template, configuration, flags);
        if (flags.contains(CacheContainerAdmin.AdminFlag.PERMANENT)) {
            this.persistentCaches.add((Object)name);
            this.storeAll();
        }
    }

    @Override
    public void removeCache(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (this.persistentCaches.remove((Object)name)) {
            this.storeAll();
        }
        super.removeCache(name, flags);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Configuration> loadAll() {
        try (FileInputStream fis = new FileInputStream(this.getPersistentFile());){
            HashMap<String, Configuration> configurations = new HashMap<String, Configuration>();
            ConfigurationBuilderHolder holder = this.parserRegistry.parse(fis);
            for (Map.Entry<String, ConfigurationBuilder> entry : holder.getNamedConfigurationBuilders().entrySet()) {
                String name = entry.getKey();
                Configuration configuration = entry.getValue().build();
                configurations.put(name, configuration);
            }
            HashMap<String, Configuration> hashMap = configurations;
            return hashMap;
        }
        catch (FileNotFoundException e) {
            return Collections.emptyMap();
        }
        catch (IOException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    private static void renameFailed(File tmpFile, File dstFile) {
        throw log.cannotRenamePersistentFile(tmpFile.getAbsolutePath(), dstFile);
    }

    private void storeAll() {
        try {
            File sharedDirectory = new File(this.globalConfiguration.globalState().sharedPersistentLocation());
            sharedDirectory.mkdirs();
            File temp = File.createTempFile("caches", null, sharedDirectory);
            HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
            for (String cacheName : this.persistentCaches) {
                configurationMap.put(cacheName, this.cacheManager.getCacheConfiguration(cacheName));
            }
            try (FileOutputStream f = new FileOutputStream(temp);){
                this.parserRegistry.serialize((OutputStream)f, null, configurationMap);
            }
            Util.renameTempFile((File)temp, (File)this.getPersistentFileLock(), (File)this.getPersistentFile(), OverlayLocalConfigurationStorage::renameFailed);
        }
        catch (Exception e) {
            throw log.errorPersistingGlobalConfiguration(e);
        }
    }

    private File getPersistentFile() {
        return new File(this.globalConfiguration.globalState().sharedPersistentLocation(), "caches.xml");
    }

    private File getPersistentFileLock() {
        return new File(this.globalConfiguration.globalState().sharedPersistentLocation(), "caches.xml.lck");
    }
}

