/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.GlobUtils;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ConfigurationManager {
    private static final Log log = LogFactory.getLog(ConfigurationManager.class);
    private final GlobalConfiguration globalConfiguration;
    private final ConcurrentMap<String, Configuration> namedConfiguration;

    public ConfigurationManager(GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
        this.namedConfiguration = CollectionFactory.makeConcurrentMap();
    }

    public ConfigurationManager(ConfigurationBuilderHolder holder) {
        this(holder.getGlobalConfigurationBuilder().build());
        holder.getNamedConfigurationBuilders().forEach((name, builder) -> this.namedConfiguration.put((String)name, builder.build(this.globalConfiguration)));
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public Configuration getConfiguration(String cacheName, boolean includeWildcards) {
        if (includeWildcards) {
            return this.findConfiguration(cacheName);
        }
        return (Configuration)this.namedConfiguration.get(cacheName);
    }

    public Configuration getConfiguration(String cacheName, String defaultCacheName) {
        Configuration configuration = this.findConfiguration(cacheName);
        if (configuration != null) {
            return configuration;
        }
        if (defaultCacheName != null) {
            return (Configuration)this.namedConfiguration.get(defaultCacheName);
        }
        throw log.noSuchCacheConfiguration(cacheName);
    }

    private Configuration findConfiguration(String name) {
        if (this.namedConfiguration.containsKey(name)) {
            return (Configuration)this.namedConfiguration.get(name);
        }
        Configuration match = null;
        for (Map.Entry c : this.namedConfiguration.entrySet()) {
            String key = (String)c.getKey();
            if (!GlobUtils.isGlob((String)key) || !name.matches(GlobUtils.globToRegex((String)key))) continue;
            if (match == null) {
                match = (Configuration)c.getValue();
                continue;
            }
            throw log.configurationNameMatchesMultipleWildcards(name);
        }
        return match;
    }

    public Configuration putConfiguration(String cacheName, Configuration configuration) {
        this.namedConfiguration.put(cacheName, configuration);
        return configuration;
    }

    public Configuration putConfiguration(String cacheName, ConfigurationBuilder builder) {
        return this.putConfiguration(cacheName, builder.build());
    }

    public void removeConfiguration(String cacheName) {
        this.namedConfiguration.remove(cacheName);
    }

    public Collection<String> getDefinedCaches() {
        List cacheNames = this.namedConfiguration.entrySet().stream().filter(entry -> !((Configuration)entry.getValue()).isTemplate() && !((String)entry.getKey()).equals("___defaultcache")).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        return Collections.unmodifiableCollection(cacheNames);
    }

    public Collection<String> getDefinedConfigurations() {
        return Collections.unmodifiableCollection(this.namedConfiguration.keySet());
    }
}

