/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class UnsignedShortElement
extends AtomicElement<UnsignedShort> {
    private final UnsignedShort _value;

    UnsignedShortElement(Element parent, Element prev, UnsignedShort ub) {
        super(parent, prev);
        this._value = ub;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 2 : 3;
    }

    @Override
    public UnsignedShort getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.USHORT;
    }

    @Override
    public int encode(ByteBuffer b) {
        if (this.isElementOfArray()) {
            if (b.remaining() >= 2) {
                b.putShort(this._value.shortValue());
                return 2;
            }
        } else if (b.remaining() >= 3) {
            b.put((byte)96);
            b.putShort(this._value.shortValue());
            return 3;
        }
        return 0;
    }
}

