/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.deployment;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.wildfly.iiop.openjdk.deployment.IIOPDeploymentMarker;
import org.wildfly.iiop.openjdk.rmi.ExceptionAnalysis;
import org.wildfly.iiop.openjdk.rmi.InterfaceAnalysis;
import org.wildfly.iiop.openjdk.rmi.ValueAnalysis;

public class IIOPMarkerProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        IIOPDeploymentMarker.mark(deploymentUnit);
    }

    public void undeploy(DeploymentUnit context) {
        Module module = (Module)context.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        ExceptionAnalysis.clearCache((ClassLoader)module.getClassLoader());
        InterfaceAnalysis.clearCache((ClassLoader)module.getClassLoader());
        ValueAnalysis.clearCache((ClassLoader)module.getClassLoader());
    }
}

