/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public abstract class AbstractAsynchronousResponse
implements ResteasyAsynchronousResponse {
    protected SynchronousDispatcher dispatcher;
    protected ResourceMethodInvoker method;
    protected HttpRequest request;
    protected HttpResponse response;
    protected ContainerResponseFilter[] responseFilters;
    protected WriterInterceptor[] writerInterceptors;
    protected Annotation[] annotations;
    protected TimeoutHandler timeoutHandler;
    protected List<CompletionCallback> completionCallbacks = new ArrayList<CompletionCallback>();
    protected Map<Class<?>, Object> contextDataMap;

    protected AbstractAsynchronousResponse(SynchronousDispatcher dispatcher, HttpRequest request, HttpResponse response) {
        this.dispatcher = dispatcher;
        this.request = request;
        this.response = response;
        this.contextDataMap = ResteasyProviderFactory.getContextDataMap();
    }

    public Collection<Class<?>> register(Class<?> callback) throws NullPointerException {
        if (callback == null) {
            throw new NullPointerException(Messages.MESSAGES.callbackWasNull());
        }
        Object cb = this.dispatcher.getProviderFactory().createProviderInstance(callback);
        return this.register(cb);
    }

    public Collection<Class<?>> register(Object callback) throws NullPointerException {
        if (callback == null) {
            throw new NullPointerException(Messages.MESSAGES.callbackWasNull());
        }
        ArrayList registered = new ArrayList();
        if (callback instanceof CompletionCallback) {
            this.completionCallbacks.add((CompletionCallback)callback);
            registered.add(CompletionCallback.class);
        }
        return registered;
    }

    public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) throws NullPointerException {
        HashMap map = new HashMap();
        map.put(callback, this.register(callback));
        for (Class<?> call : callbacks) {
            map.put(call, this.register(call));
        }
        return map;
    }

    public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) throws NullPointerException {
        HashMap map = new HashMap();
        map.put(callback.getClass(), this.register(callback));
        for (Object call : callbacks) {
            map.put(call.getClass(), this.register(call));
        }
        return map;
    }

    public void setTimeoutHandler(TimeoutHandler handler) {
        this.timeoutHandler = handler;
    }

    @Override
    public ResourceMethodInvoker getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(ResourceMethodInvoker method) {
        this.method = method;
    }

    @Override
    public ContainerResponseFilter[] getResponseFilters() {
        return this.responseFilters;
    }

    @Override
    public void setResponseFilters(ContainerResponseFilter[] responseFilters) {
        this.responseFilters = responseFilters;
    }

    @Override
    public WriterInterceptor[] getWriterInterceptors() {
        return this.writerInterceptors;
    }

    @Override
    public void setWriterInterceptors(WriterInterceptor[] writerInterceptors) {
        this.writerInterceptors = writerInterceptors;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    @Override
    public void completionCallbacks(Throwable throwable) {
        for (CompletionCallback callback : this.completionCallbacks) {
            callback.onComplete(throwable);
        }
    }

    @Deprecated
    protected boolean internalResume(Object entity) {
        return this.internalResume(entity, (Throwable t) -> {});
    }

    protected boolean internalResume(Object entity, Consumer<Throwable> onComplete) {
        ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
        Response response = null;
        if (entity == null) {
            response = Response.noContent().build();
        } else if (entity instanceof Response) {
            response = (Response)entity;
        } else {
            if (this.method == null) {
                throw new IllegalStateException(Messages.MESSAGES.unknownMediaTypeResponseEntity());
            }
            MediaType type = this.method.resolveContentType(this.request, entity);
            BuiltResponse jaxrsResponse = (BuiltResponse)Response.ok((Object)entity, (MediaType)type).build();
            jaxrsResponse.setGenericType(this.method.getGenericReturnType());
            jaxrsResponse.addMethodAnnotations(this.method.getMethodAnnotations());
            response = jaxrsResponse;
        }
        try {
            this.dispatcher.asynchronousDelivery(this.request, this.response, response, t -> {
                if (t != null) {
                    this.internalResume((Throwable)t, (Throwable t2) -> onComplete.accept((Throwable)t));
                } else {
                    onComplete.accept(null);
                    this.completionCallbacks(null);
                }
            });
        }
        catch (Throwable e) {
            return this.internalResume(e, (Throwable t) -> onComplete.accept(e));
        }
        return true;
    }

    @Deprecated
    protected boolean internalResume(Throwable exc) {
        return this.internalResume(exc, (Throwable t) -> {});
    }

    protected boolean internalResume(Throwable exc, Consumer<Throwable> onComplete) {
        ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
        this.dispatcher.asynchronousExceptionDelivery(this.request, this.response, exc, t -> {
            onComplete.accept((Throwable)t);
            this.completionCallbacks(exc);
        });
        return true;
    }
}

