/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossExecutors;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.SuppliedValueService;

public class CachedThreadPoolExecutorServiceBuilder
implements Builder<ExecutorService>,
Function<ExecutorService, ExecutorService>,
Supplier<ExecutorService>,
Consumer<ExecutorService> {
    private final ServiceName name;
    private final ThreadFactory factory;

    public CachedThreadPoolExecutorServiceBuilder(ServiceName name, ThreadFactory factory) {
        this.name = name;
        this.factory = factory;
    }

    @Override
    public ExecutorService apply(ExecutorService executor) {
        return JBossExecutors.protectedExecutorService((Executor)executor);
    }

    @Override
    public ExecutorService get() {
        return Executors.newCachedThreadPool(this.factory);
    }

    @Override
    public void accept(ExecutorService executor) {
        executor.shutdownNow();
    }

    @Override
    public ServiceName getServiceName() {
        return this.name;
    }

    @Override
    public ServiceBuilder<ExecutorService> build(ServiceTarget target) {
        SuppliedValueService<ExecutorService, ExecutorService> service = new SuppliedValueService<ExecutorService, ExecutorService>(this, this, this);
        return new AsynchronousServiceBuilder(this.name, service).startSynchronously().build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

