/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.spi;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.impl.lucene.WorkspaceHolder;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.cfg.spi.DirectoryProviderService;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.impl.PropertiesParseHelper;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.impl.Closer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DirectoryBasedIndexManager
implements IndexManager {
    private static Log log = LoggerFactory.make(MethodHandles.lookup());
    private String indexName;
    private DirectoryProvider<?> directoryProvider;
    private Similarity similarity;
    private WorkspaceHolder workspaceHolder;
    private OptimizerStrategy optimizer;
    private LuceneIndexingParameters indexingParameters;
    private IndexedTypeSet containedEntityTypes = IndexedTypeSets.empty();
    private LuceneWorkSerializer serializer;
    private ExtendedSearchIntegrator boundSearchIntegrator = null;
    private DirectoryBasedReaderProvider readers = null;
    private ServiceManager serviceManager;

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public ReaderProvider getReaderProvider() {
        return this.readers;
    }

    @Override
    public void destroy() {
        try (Closer closer = new Closer();){
            closer.push(this.readers::stop);
            closer.push(this.workspaceHolder::close);
            closer.push(this.directoryProvider::stop);
            if (this.serializer != null) {
                closer.push(this.serviceManager::releaseService, LuceneWorkSerializer.class);
            }
        }
    }

    @Override
    public void initialize(String indexName, Properties properties, Similarity similarity, WorkerBuildContext buildContext) {
        this.serviceManager = buildContext.getServiceManager();
        this.indexName = indexName;
        this.similarity = similarity;
        this.directoryProvider = this.createDirectoryProvider(indexName, properties, buildContext);
        this.indexingParameters = PropertiesParseHelper.extractIndexingPerformanceOptions(properties);
        this.optimizer = PropertiesParseHelper.getOptimizerStrategy(this, properties, buildContext);
        this.workspaceHolder = this.createWorkspaceHolder(indexName, properties, buildContext);
        this.directoryProvider.start(this);
        this.readers = this.createIndexReader(indexName, properties, buildContext);
    }

    @Override
    public IndexedTypeSet getContainedTypes() {
        return this.containedEntityTypes;
    }

    @Override
    public Similarity getSimilarity() {
        return this.similarity;
    }

    @Override
    public void performStreamOperation(LuceneWork singleOperation, IndexingMonitor monitor, boolean forceAsync) {
        this.workspaceHolder.applyStreamWork(singleOperation, monitor);
    }

    @Override
    public void awaitAsyncProcessingCompletion() {
    }

    @Override
    public void performOperations(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (log.isDebugEnabled()) {
            log.debug("Applying work via workspace holder of type " + this.workspaceHolder.getClass());
        }
        this.workspaceHolder.applyWork(workList, monitor);
    }

    public String toString() {
        return "DirectoryBasedIndexManager [indexName=" + this.indexName + "]";
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.boundSearchIntegrator.getAnalyzer(name);
    }

    @Override
    public void setSearchFactory(ExtendedSearchIntegrator boundSearchIntegrator) {
        this.boundSearchIntegrator = boundSearchIntegrator;
        this.triggerWorkspaceReconfiguration();
    }

    @Override
    public void addContainedEntity(IndexedTypeIdentifier entity) {
        IndexedTypeSet oldSet = this.containedEntityTypes;
        IndexedTypeSet newSet = IndexedTypeSets.composite(oldSet, entity);
        if (!oldSet.equals(newSet)) {
            this.containedEntityTypes = newSet;
            this.triggerWorkspaceReconfiguration();
        }
    }

    @Override
    public void optimize() {
        this.performStreamOperation(OptimizeLuceneWork.INSTANCE, null, false);
    }

    @Override
    public LuceneWorkSerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = this.requestSerializer();
            log.indexManagerUsesSerializationService(this.indexName, this.serializer.describeSerializer());
        }
        return this.serializer;
    }

    @Override
    public void flushAndReleaseResources() {
        this.workspaceHolder.flushAndReleaseResources();
    }

    private LuceneWorkSerializer requestSerializer() {
        try {
            return this.serviceManager.requestService(LuceneWorkSerializer.class);
        }
        catch (SearchException se) {
            throw log.serializationProviderNotFoundException(se);
        }
    }

    public WorkspaceHolder getWorkspaceHolder() {
        return this.workspaceHolder;
    }

    public EntityIndexBinding getIndexBinding(IndexedTypeIdentifier type) {
        return this.boundSearchIntegrator.getIndexBinding(type);
    }

    public Lock getDirectoryModificationLock() {
        return this.workspaceHolder.getExclusiveWriteLock();
    }

    public DirectoryProvider<?> getDirectoryProvider() {
        return this.directoryProvider;
    }

    public OptimizerStrategy getOptimizerStrategy() {
        return this.optimizer;
    }

    public LuceneIndexingParameters getIndexingParameters() {
        return this.indexingParameters;
    }

    private void triggerWorkspaceReconfiguration() {
        if (this.boundSearchIntegrator != null) {
            this.workspaceHolder.indexMappingChanged();
        }
    }

    protected WorkspaceHolder createWorkspaceHolder(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        WorkspaceHolder backend = new WorkspaceHolder();
        backend.initialize(cfg, buildContext, this);
        return backend;
    }

    protected DirectoryBasedReaderProvider createIndexReader(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        return PropertiesParseHelper.createDirectoryBasedReaderProvider(this, cfg, buildContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirectoryProvider<?> createDirectoryProvider(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        try {
            DirectoryProviderService directoryProviderService = this.serviceManager.requestService(DirectoryProviderService.class);
            DirectoryProvider directoryProvider = directoryProviderService.create(cfg, indexName, buildContext);
            return directoryProvider;
        }
        finally {
            this.serviceManager.releaseService(DirectoryProviderService.class);
        }
    }

    @Override
    public IndexManagerType getIndexManagerType() {
        return LuceneEmbeddedIndexManagerType.INSTANCE;
    }
}

