/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.deployment;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommand;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.parser.CommandLineParserException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.CLICommandRegistry;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DeployArchiveCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DeployFileCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DeployUrlCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DisableAllCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DisableCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.EnableAllCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.EnableCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.InfoCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.ListCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.UndeployArchiveCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.UndeployCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.AccessRequirements;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.CommandWithPermissions;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.Permissions;
import org.jboss.as.cli.impl.aesh.cmd.security.ControlledCommandActivator;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

@GroupCommandDefinition(name="deployment", description="", activator=ControlledCommandActivator.class)
public class DeploymentCommand
extends CommandWithPermissions
implements GroupCommand<CLICommandInvocation, Command> {
    public DeploymentCommand(CommandContext ctx, Permissions permissions) {
        super(ctx, AccessRequirements.deploymentAccess(permissions), permissions);
    }

    public static void registerDeploymentCommands(CommandContext ctx, CLICommandRegistry registry) throws CommandLineException, CommandLineParserException {
        Permissions p = new Permissions(ctx);
        DeploymentCommand deploy = new DeploymentCommand(ctx, p);
        registry.addCommand(deploy);
    }

    @Deprecated
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        throw new CommandException("Command action is missing.");
    }

    public List<Command> getCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(new EnableCommand(this.getCommandContext(), this.getPermissions()));
        commands.add(new EnableAllCommand(this.getCommandContext(), this.getPermissions()));
        commands.add(new DeployArchiveCommand(this.getCommandContext(), this.getPermissions()));
        commands.add(new DeployUrlCommand(this.getCommandContext(), this.getPermissions()));
        commands.add(new DeployFileCommand(this.getCommandContext(), this.getPermissions()));
        commands.add(new ListCommand(this.getCommandContext(), this.getPermissions()));
        commands.add(new InfoCommand(this.getCommandContext(), this.getPermissions()));
        commands.add(new UndeployCommand(this.getCommandContext(), this.getPermissions()));
        commands.add(new DisableAllCommand(this.getCommandContext(), this.getPermissions()));
        commands.add(new DisableCommand(this.getCommandContext(), this.getPermissions()));
        commands.add(new UndeployArchiveCommand(this.getCommandContext(), this.getPermissions()));
        return commands;
    }

    static List<String> getServerGroups(CommandContext ctx, ModelControllerClient client, boolean allServerGroups, String serverGroups, File f) throws CommandFormatException {
        List<String> sgList = null;
        if (ctx.isDomainMode()) {
            if (allServerGroups) {
                if (serverGroups != null) {
                    throw new CommandFormatException("--all-server-groups and --server-groups can't appear in the same command");
                }
                sgList = Util.getServerGroups(client);
                if (sgList.isEmpty()) {
                    throw new CommandFormatException("No server group is available.");
                }
            } else {
                if (serverGroups == null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("One of ");
                    if (f != null) {
                        buf.append("--disabled,");
                    }
                    buf.append(" --all-server-groups or --server-groups is missing.");
                    throw new CommandFormatException(buf.toString());
                }
                sgList = Arrays.asList(serverGroups.split(","));
                if (sgList.isEmpty()) {
                    throw new CommandFormatException("Couldn't locate server group name in '--server-groups=" + serverGroups + "'.");
                }
            }
        } else if (serverGroups != null || allServerGroups) {
            throw new CommandFormatException("--server-groups and --all-server-groups can't appear in standalone mode.");
        }
        return sgList;
    }
}

