/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.StabilityStatistics;

public final class StabilityMonitor {
    private final Object stabilityLock = new Object();
    private final Object controllersLock = new Object();
    private final Set<ServiceController<?>> problems = new IdentityHashSet();
    private final Set<ServiceController<?>> failed = new IdentityHashSet();
    private IdentityHashSet<ServiceControllerImpl<?>> controllers = new IdentityHashSet();
    private boolean addInProgress;
    private boolean cleanupInProgress;
    private boolean removeInProgress;
    private int unstableServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addController(ServiceController<?> controller) throws IllegalArgumentException, IllegalStateException {
        boolean addMonitorToController;
        if (controller == null) {
            throw new IllegalArgumentException("Controller is null");
        }
        if (Thread.holdsLock(controller)) {
            throw new IllegalStateException("Controller lock is held");
        }
        ServiceControllerImpl serviceController = (ServiceControllerImpl)controller;
        Object object = this.controllersLock;
        synchronized (object) {
            this.awaitCleanupCompletion();
            this.awaitAddCompletion();
            this.addInProgress = addMonitorToController = this.controllers.add(serviceController);
        }
        if (!addMonitorToController) {
            return;
        }
        serviceController.addMonitor(this);
        object = this.controllersLock;
        synchronized (object) {
            this.addInProgress = false;
            this.controllersLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addControllerNoCallback(ServiceControllerImpl<?> controller) {
        Object object = this.controllersLock;
        synchronized (object) {
            this.awaitCleanupCompletion();
            this.controllers.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeController(ServiceController<?> controller) throws IllegalArgumentException, IllegalStateException {
        boolean removeMonitorFromController;
        if (controller == null) {
            throw new IllegalArgumentException("Controller is null");
        }
        if (Thread.holdsLock(controller)) {
            throw new IllegalStateException("Controller lock is held");
        }
        ServiceControllerImpl serviceController = (ServiceControllerImpl)controller;
        Object object = this.controllersLock;
        synchronized (object) {
            if (this.cleanupInProgress) {
                return;
            }
            this.awaitRemoveCompletion();
            this.removeInProgress = removeMonitorFromController = this.controllers.remove(serviceController);
        }
        if (!removeMonitorFromController) {
            return;
        }
        serviceController.removeMonitor(this);
        object = this.controllersLock;
        synchronized (object) {
            this.removeInProgress = false;
            this.controllersLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeControllerNoCallback(ServiceControllerImpl<?> controller) {
        Object object = this.controllersLock;
        synchronized (object) {
            if (!this.cleanupInProgress) {
                this.controllers.remove(controller);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        IdentityHashSet<ServiceControllerImpl<?>> controllers;
        Object object2 = this.controllersLock;
        synchronized (object2) {
            Object object = this.stabilityLock;
            synchronized (object) {
                if (this.cleanupInProgress) {
                    return;
                }
                this.cleanupInProgress = true;
                controllers = this.controllers;
                this.controllers = new IdentityHashSet();
                this.failed.clear();
                this.problems.clear();
                this.unstableServices = 0;
            }
        }
        try {
            for (ServiceControllerImpl serviceControllerImpl : controllers) {
                serviceControllerImpl.removeMonitorNoCallback(this);
            }
        }
        finally {
            object2 = this.controllersLock;
            synchronized (object2) {
                Object object = this.stabilityLock;
                synchronized (object) {
                    this.cleanupInProgress = false;
                    this.stabilityLock.notifyAll();
                }
                this.controllersLock.notifyAll();
            }
        }
    }

    public void awaitStability() throws InterruptedException {
        this.awaitStability(null, null, null);
    }

    public void awaitStability(StabilityStatistics statistics) throws InterruptedException {
        this.awaitStability(null, null, statistics);
    }

    public boolean awaitStability(long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitStability(timeout, unit, null, null, null);
    }

    public boolean awaitStability(long timeout, TimeUnit unit, StabilityStatistics statistics) throws InterruptedException {
        return this.awaitStability(timeout, unit, null, null, statistics);
    }

    public void awaitStability(Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problems) throws InterruptedException {
        this.awaitStability(failed, problems, null);
    }

    public boolean awaitStability(long timeout, TimeUnit unit, Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problems) throws InterruptedException {
        return this.awaitStability(timeout, unit, failed, problems, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitStability(Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problems, StabilityStatistics statistics) throws InterruptedException {
        int problemsCount;
        int failedCount;
        Object object = this.stabilityLock;
        synchronized (object) {
            while (this.unstableServices != 0) {
                this.stabilityLock.wait();
            }
            if (failed != null) {
                failed.addAll(this.failed);
            }
            failedCount = this.failed.size();
            if (problems != null) {
                problems.addAll(this.problems);
            }
            problemsCount = this.problems.size();
        }
        this.provideStatistics(failedCount, problemsCount, statistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitStability(long timeout, TimeUnit unit, Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problems, StabilityStatistics statistics) throws InterruptedException {
        int problemsCount;
        int failedCount;
        long now = System.nanoTime();
        long remaining = unit.toNanos(timeout);
        Object object = this.stabilityLock;
        synchronized (object) {
            while (this.unstableServices != 0) {
                if (remaining <= 0L) {
                    return false;
                }
                this.stabilityLock.wait(remaining / 1000000L, (int)(remaining % 1000000L));
                long l = -now;
                now = System.nanoTime();
                remaining -= l + now;
            }
            if (failed != null) {
                failed.addAll(this.failed);
            }
            failedCount = this.failed.size();
            if (problems != null) {
                problems.addAll(this.problems);
            }
            problemsCount = this.problems.size();
        }
        this.provideStatistics(failedCount, problemsCount, statistics);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProblem(ServiceController<?> controller) {
        assert (Thread.holdsLock(controller));
        Object object = this.stabilityLock;
        synchronized (object) {
            if (this.cleanupInProgress) {
                return;
            }
            this.problems.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProblem(ServiceController<?> controller) {
        assert (Thread.holdsLock(controller));
        Object object = this.stabilityLock;
        synchronized (object) {
            if (this.cleanupInProgress) {
                return;
            }
            this.problems.remove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailed(ServiceController<?> controller) {
        assert (Thread.holdsLock(controller));
        Object object = this.stabilityLock;
        synchronized (object) {
            if (this.cleanupInProgress) {
                return;
            }
            this.failed.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFailed(ServiceController<?> controller) {
        assert (Thread.holdsLock(controller));
        Object object = this.stabilityLock;
        synchronized (object) {
            if (this.cleanupInProgress) {
                return;
            }
            this.failed.remove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementUnstableServices() {
        Object object = this.stabilityLock;
        synchronized (object) {
            if (this.cleanupInProgress) {
                return;
            }
            ++this.unstableServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementUnstableServices() {
        Object object = this.stabilityLock;
        synchronized (object) {
            if (this.cleanupInProgress) {
                return;
            }
            if (--this.unstableServices == 0) {
                this.stabilityLock.notifyAll();
            }
            assert (this.unstableServices >= 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void provideStatistics(int failedCount, int problemsCount, StabilityStatistics statistics) {
        Object controllers;
        assert (!Thread.holdsLock(this.stabilityLock));
        assert (!Thread.holdsLock(this.controllersLock));
        if (statistics == null) {
            return;
        }
        Object object = this.controllersLock;
        synchronized (object) {
            controllers = this.controllers.clone();
        }
        int active = 0;
        int lazy = 0;
        int onDemand = 0;
        int never = 0;
        int passive = 0;
        int started = 0;
        Iterator iterator = controllers.iterator();
        while (iterator.hasNext()) {
            ServiceController controller = (ServiceController)iterator.next();
            if (controller.getState() == ServiceController.State.UP) {
                ++started;
            }
            if (controller.getMode() == ServiceController.Mode.ACTIVE) {
                ++active;
                continue;
            }
            if (controller.getMode() == ServiceController.Mode.PASSIVE) {
                ++passive;
                continue;
            }
            if (controller.getMode() == ServiceController.Mode.ON_DEMAND) {
                ++onDemand;
                continue;
            }
            if (controller.getMode() == ServiceController.Mode.NEVER) {
                ++never;
                continue;
            }
            if (controller.getMode() != ServiceController.Mode.LAZY) continue;
            ++lazy;
        }
        statistics.setActiveCount(active);
        statistics.setFailedCount(failedCount);
        statistics.setLazyCount(lazy);
        statistics.setOnDemandCount(onDemand);
        statistics.setNeverCount(never);
        statistics.setPassiveCount(passive);
        statistics.setProblemsCount(problemsCount);
        statistics.setStartedCount(started);
    }

    private void awaitAddCompletion() {
        assert (Thread.holdsLock(this.controllersLock));
        boolean interrupted = false;
        try {
            while (this.addInProgress) {
                try {
                    this.controllersLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void awaitCleanupCompletion() {
        assert (Thread.holdsLock(this.controllersLock));
        boolean interrupted = false;
        try {
            while (this.cleanupInProgress) {
                try {
                    this.controllersLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void awaitRemoveCompletion() {
        assert (Thread.holdsLock(this.controllersLock));
        boolean interrupted = false;
        try {
            while (this.removeInProgress) {
                try {
                    this.controllersLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

