/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.IterableModuleFinder;
import org.jboss.modules.JDKSpecific;
import org.jboss.modules.LocalDependencySpecBuilder;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.PathFilters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JDKModuleFinder
implements IterableModuleFinder {
    private final ConcurrentHashMap<String, FutureSpec> modules = new ConcurrentHashMap();
    private final List<String> moduleNames = Collections.unmodifiableList(Arrays.asList("java.sql", "java.base", "java.compiler", "java.datatransfer", "java.desktop", "java.instrument", "java.jnlp", "java.logging", "java.management", "java.management.rmi", "java.naming", "java.prefs", "java.rmi", "java.scripting", "java.security.jgss", "java.security.sasl", "java.smartcardio", "java.sql.rowset", "java.xml", "java.xml.crypto", "javafx.base", "javafx.controls", "javafx.fxml", "javafx.graphics", "javafx.media", "javafx.swing", "javafx.web", "jdk.accessibility", "jdk.attach", "jdk.compiler", "jdk.httpserver", "jdk.jartool", "jdk.javadoc", "jdk.jconsole", "jdk.jdi", "jdk.jfr", "jdk.jsobject", "jdk.management", "jdk.management.cmm", "jdk.management.jfr", "jdk.management.resource", "jdk.net", "jdk.plugin.dom", "jdk.scripting.nashorn", "jdk.sctp", "jdk.security.auth", "jdk.security.jgss", "jdk.unsupported", "jdk.xml.dom", "org.jboss.modules"));
    private static final JDKModuleFinder INSTANCE = new JDKModuleFinder();

    private JDKModuleFinder() {
    }

    public static JDKModuleFinder getInstance() {
        return INSTANCE;
    }

    @Override
    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) throws ModuleLoadException {
        FutureSpec futureSpec = this.modules.get(name);
        if (futureSpec == null) {
            futureSpec = new FutureSpec();
            FutureSpec appearing = this.modules.putIfAbsent(name, futureSpec);
            if (appearing != null) {
                futureSpec = appearing;
            } else {
                switch (name) {
                    case "java.se": {
                        ModuleSpec.Builder builder = ModuleSpec.build("java.se", false);
                        for (DependencySpec dep : SEDeps.javaSeDeps) {
                            builder.addDependency(dep);
                        }
                        futureSpec.setModuleSpec(builder.create());
                        break;
                    }
                    default: {
                        ModuleSpec moduleSpec = this.loadModuleSpec(name);
                        futureSpec.setModuleSpec(moduleSpec);
                        if (moduleSpec != null) break;
                        this.modules.remove(name, futureSpec);
                        break;
                    }
                }
            }
        }
        return futureSpec.getModuleSpec();
    }

    @Override
    public Iterator<String> iterateModules(String baseName, boolean recursive) {
        return this.moduleNames.iterator();
    }

    private ModuleSpec loadModuleSpec(String name) throws ModuleLoadException {
        HashSet<String> paths = new HashSet<String>();
        InputStream is = this.getClass().getResourceAsStream("/jdk-module-paths/" + name);
        if (is == null) {
            return null;
        }
        try (InputStream tmp = is;
             InputStreamReader isr = new InputStreamReader(tmp, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.isEmpty() || trimmed.startsWith("#")) continue;
                paths.add(trimmed);
            }
        }
        catch (IOException e) {
            throw new ModuleLoadException(e);
        }
        ModuleSpec.Builder builder = ModuleSpec.build(name, false);
        LocalDependencySpecBuilder dependencySpecBuilder = new LocalDependencySpecBuilder();
        dependencySpecBuilder.setLoaderPaths(paths);
        dependencySpecBuilder.setExport(true);
        dependencySpecBuilder.setImportFilter(PathFilters.acceptAll());
        dependencySpecBuilder.setLocalLoader(JDKSpecific.getSystemLocalLoader());
        builder.addDependency(dependencySpecBuilder.build());
        return builder.create();
    }

    public String toString() {
        return "JDK Module Finder";
    }

    static final class FutureSpec {
        private static final ModuleSpec MARKER = ModuleSpec.build("dummy").create();
        private volatile ModuleSpec moduleSpec = MARKER;

        FutureSpec() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setModuleSpec(ModuleSpec moduleSpec) {
            FutureSpec futureSpec = this;
            synchronized (futureSpec) {
                this.moduleSpec = moduleSpec;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ModuleSpec getModuleSpec() {
            ModuleSpec moduleSpec = this.moduleSpec;
            if (moduleSpec == MARKER) {
                FutureSpec futureSpec = this;
                synchronized (futureSpec) {
                    moduleSpec = this.moduleSpec;
                    boolean intr = false;
                    try {
                        while (moduleSpec == MARKER) {
                            try {
                                this.wait();
                                moduleSpec = this.moduleSpec;
                            }
                            catch (InterruptedException e) {
                                intr = true;
                            }
                        }
                    }
                    finally {
                        if (intr) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            return moduleSpec;
        }
    }

    static final class SEDeps {
        static final List<DependencySpec> javaSeDeps;

        SEDeps() {
        }

        static {
            ArrayList<DependencySpec> deps = new ArrayList<DependencySpec>();
            for (String dep : Arrays.asList("java.compiler", "java.datatransfer", "java.desktop", "java.instrument", "java.logging", "java.management", "java.management.rmi", "java.naming", "java.prefs", "java.rmi", "java.scripting", "java.security.jgss", "java.security.sasl", "java.sql", "java.sql.rowset", "java.xml", "java.xml.crypto")) {
                deps.add(new ModuleDependencySpecBuilder().setName(dep).setExport(true).build());
            }
            javaSeDeps = deps;
        }
    }
}

