/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.sasl;

import org.apache.activemq.artemis.protocol.amqp.sasl.PlainSASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;

public class ServerSASLPlain
implements ServerSASL {
    public static final String NAME = "PLAIN";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public SASLResult processSASL(byte[] data) {
        String username = null;
        String password = null;
        String bytes = new String(data);
        String[] credentials = bytes.split(Character.toString('\u0000'));
        int offSet = 0;
        if (credentials.length > 0) {
            if (credentials[0].length() == 0) {
                offSet = 1;
            }
            if (credentials.length >= offSet) {
                username = credentials[offSet];
            }
            if (credentials.length >= offSet + 1) {
                password = credentials[offSet + 1];
            }
        }
        boolean success = this.authenticate(username, password);
        return new PlainSASLResult(success, username, password);
    }

    protected boolean authenticate(String user, String password) {
        return true;
    }
}

