/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.message;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.artemis.core.buffers.impl.ResetLimitWrappedActiveMQBuffer;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.impl.ServerMessageImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSBytesMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMapMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSObjectMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSStreamMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSTextMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.message.AMQPContentTypeSupport;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInvalidContentTypeException;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.message.Message;

public final class AMQPMessageSupport {
    public static final String JMS_AMQP_PREFIX = "JMS_AMQP_";
    public static final int JMS_AMQP_PREFIX_LENGTH = "JMS_AMQP_".length();
    public static final String MESSAGE_FORMAT = "MESSAGE_FORMAT";
    public static final String ORIGINAL_ENCODING = "ORIGINAL_ENCODING";
    public static final String NATIVE = "NATIVE";
    public static final String HEADER = "HEADER";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String FIRST_ACQUIRER = "FirstAcquirer";
    public static final String CONTENT_TYPE = "ContentType";
    public static final String CONTENT_ENCODING = "ContentEncoding";
    public static final String REPLYTO_GROUP_ID = "ReplyToGroupID";
    public static final String DELIVERY_ANNOTATION_PREFIX = "DA_";
    public static final String MESSAGE_ANNOTATION_PREFIX = "MA_";
    public static final String FOOTER_PREFIX = "FT_";
    public static final String JMS_AMQP_HEADER = "JMS_AMQP_HEADER";
    public static final String JMS_AMQP_PROPERTIES = "JMS_AMQP_PROPERTIES";
    public static final String JMS_AMQP_ORIGINAL_ENCODING = "JMS_AMQP_ORIGINAL_ENCODING";
    public static final String JMS_AMQP_MESSAGE_FORMAT = "JMS_AMQP_MESSAGE_FORMAT";
    public static final String JMS_AMQP_NATIVE = "JMS_AMQP_NATIVE";
    public static final String JMS_AMQP_FIRST_ACQUIRER = "JMS_AMQP_FirstAcquirer";
    public static final String JMS_AMQP_CONTENT_TYPE = "JMS_AMQP_ContentType";
    public static final String JMS_AMQP_CONTENT_ENCODING = "JMS_AMQP_ContentEncoding";
    public static final String JMS_AMQP_REPLYTO_GROUP_ID = "JMS_AMQP_ReplyToGroupID";
    public static final String JMS_AMQP_DELIVERY_ANNOTATION_PREFIX = "JMS_AMQP_DA_";
    public static final String JMS_AMQP_MESSAGE_ANNOTATION_PREFIX = "JMS_AMQP_MA_";
    public static final String JMS_AMQP_FOOTER_PREFIX = "JMS_AMQP_FT_";
    public static final Binary EMPTY_BINARY = new Binary(new byte[0]);
    public static final Data EMPTY_BODY = new Data(EMPTY_BINARY);
    public static final short AMQP_UNKNOWN = 0;
    public static final short AMQP_NULL = 1;
    public static final short AMQP_DATA = 2;
    public static final short AMQP_SEQUENCE = 3;
    public static final short AMQP_VALUE_NULL = 4;
    public static final short AMQP_VALUE_STRING = 5;
    public static final short AMQP_VALUE_BINARY = 6;
    public static final short AMQP_VALUE_MAP = 7;
    public static final short AMQP_VALUE_LIST = 8;
    public static final String SERIALIZED_JAVA_OBJECT_CONTENT_TYPE = "application/x-java-serialized-object";
    public static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";

    public static Symbol getSymbol(String key) {
        return Symbol.valueOf((String)key);
    }

    public static Object getMessageAnnotation(String key, Message message) {
        if (message != null && message.getMessageAnnotations() != null) {
            Map annotations = message.getMessageAnnotations().getValue();
            return annotations.get(AMQPMessageSupport.getSymbol(key));
        }
        return null;
    }

    public static boolean isContentType(String contentType, Message message) {
        if (contentType == null) {
            return message.getContentType() == null;
        }
        return contentType.equals(message.getContentType());
    }

    public static Charset getCharsetForTextualContent(String contentType) {
        try {
            return AMQPContentTypeSupport.parseContentTypeForTextualCharset(contentType);
        }
        catch (ActiveMQAMQPInvalidContentTypeException e) {
            return null;
        }
    }

    public static ServerJMSMessage wrapMessage(int messageType, ServerMessage wrapped, int deliveryCount) {
        switch (messageType) {
            case 6: {
                return new ServerJMSStreamMessage((MessageInternal)wrapped, deliveryCount);
            }
            case 4: {
                return new ServerJMSBytesMessage((MessageInternal)wrapped, deliveryCount);
            }
            case 5: {
                return new ServerJMSMapMessage((MessageInternal)wrapped, deliveryCount);
            }
            case 3: {
                return new ServerJMSTextMessage((MessageInternal)wrapped, deliveryCount);
            }
            case 2: {
                return new ServerJMSObjectMessage((MessageInternal)wrapped, deliveryCount);
            }
        }
        return new ServerJMSMessage((MessageInternal)wrapped, deliveryCount);
    }

    public static String toAddress(Destination destination) {
        if (destination instanceof ActiveMQDestination) {
            return ((ActiveMQDestination)destination).getAddress();
        }
        return null;
    }

    public static ServerJMSBytesMessage createBytesMessage(IDGenerator idGenerator) {
        return new ServerJMSBytesMessage((MessageInternal)AMQPMessageSupport.newMessage(idGenerator, (byte)4), 0);
    }

    public static ServerJMSMessage createBytesMessage(IDGenerator idGenerator, byte[] array, int arrayOffset, int length) throws JMSException {
        ServerJMSBytesMessage message = AMQPMessageSupport.createBytesMessage(idGenerator);
        message.writeBytes(array, arrayOffset, length);
        return message;
    }

    public static ServerJMSStreamMessage createStreamMessage(IDGenerator idGenerator) {
        return new ServerJMSStreamMessage((MessageInternal)AMQPMessageSupport.newMessage(idGenerator, (byte)6), 0);
    }

    public static ServerJMSMessage createMessage(IDGenerator idGenerator) {
        return new ServerJMSMessage((MessageInternal)AMQPMessageSupport.newMessage(idGenerator, (byte)0), 0);
    }

    public static ServerJMSTextMessage createTextMessage(IDGenerator idGenerator) {
        return new ServerJMSTextMessage((MessageInternal)AMQPMessageSupport.newMessage(idGenerator, (byte)3), 0);
    }

    public static ServerJMSTextMessage createTextMessage(IDGenerator idGenerator, String text) throws JMSException {
        ServerJMSTextMessage message = AMQPMessageSupport.createTextMessage(idGenerator);
        message.setText(text);
        return message;
    }

    public static ServerJMSObjectMessage createObjectMessage(IDGenerator idGenerator) {
        return new ServerJMSObjectMessage((MessageInternal)AMQPMessageSupport.newMessage(idGenerator, (byte)2), 0);
    }

    public static ServerJMSMessage createObjectMessage(IDGenerator idGenerator, Binary serializedForm) throws JMSException {
        ServerJMSObjectMessage message = AMQPMessageSupport.createObjectMessage(idGenerator);
        message.setSerializedForm(serializedForm);
        return message;
    }

    public static ServerJMSMessage createObjectMessage(IDGenerator idGenerator, byte[] array, int offset, int length) throws JMSException {
        ServerJMSObjectMessage message = AMQPMessageSupport.createObjectMessage(idGenerator);
        message.setSerializedForm(new Binary(array, offset, length));
        return message;
    }

    public static ServerJMSMapMessage createMapMessage(IDGenerator idGenerator) {
        return new ServerJMSMapMessage((MessageInternal)AMQPMessageSupport.newMessage(idGenerator, (byte)5), 0);
    }

    public static ServerJMSMapMessage createMapMessage(IDGenerator idGenerator, Map<String, Object> content) throws JMSException {
        ServerJMSMapMessage message = AMQPMessageSupport.createMapMessage(idGenerator);
        Set<Map.Entry<String, Object>> set = content.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            Object value = entry.getValue();
            if (value instanceof Binary) {
                Binary binary = (Binary)value;
                value = Arrays.copyOfRange(binary.getArray(), binary.getArrayOffset(), binary.getLength());
            }
            message.setObject(entry.getKey(), value);
        }
        return message;
    }

    private static ServerMessageImpl newMessage(IDGenerator idGenerator, byte messageType) {
        ServerMessageImpl message = new ServerMessageImpl(idGenerator.generateID(), 512);
        message.setType(messageType);
        ((ResetLimitWrappedActiveMQBuffer)message.getBodyBuffer()).setMessage(null);
        return message;
    }
}

