/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager.transport;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.resource.spi.work.DistributableWork;
import javax.resource.spi.work.WorkException;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.workmanager.transport.AddWorkManagerCommand;
import org.jboss.as.connector.services.workmanager.transport.ClearDistributedStatisticsCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaDoWorkAcceptedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaDoWorkRejectedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaScheduleWorkAcceptedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaScheduleWorkRejectedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaStartWorkAcceptedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaStartWorkRejectedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaWorkFailedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaWorkSuccessfulCommand;
import org.jboss.as.connector.services.workmanager.transport.DistributedStatisticsCommand;
import org.jboss.as.connector.services.workmanager.transport.DoWorkCommand;
import org.jboss.as.connector.services.workmanager.transport.GetWorkManagersCommand;
import org.jboss.as.connector.services.workmanager.transport.JoinCommand;
import org.jboss.as.connector.services.workmanager.transport.LeaveCommand;
import org.jboss.as.connector.services.workmanager.transport.LongRunningFreeCommand;
import org.jboss.as.connector.services.workmanager.transport.PingCommand;
import org.jboss.as.connector.services.workmanager.transport.RemoveWorkManagerCommand;
import org.jboss.as.connector.services.workmanager.transport.ScheduleWorkCommand;
import org.jboss.as.connector.services.workmanager.transport.ShortRunningFreeCommand;
import org.jboss.as.connector.services.workmanager.transport.StartWorkCommand;
import org.jboss.as.connector.services.workmanager.transport.UpdateLongRunningFreeCommand;
import org.jboss.as.connector.services.workmanager.transport.UpdateShortRunningFreeCommand;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.workmanager.transport.remote.AbstractRemoteTransport;
import org.jboss.jca.core.workmanager.transport.remote.ProtocolMessages;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.GroupListener;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;
import org.wildfly.clustering.service.concurrent.StampedLockServiceExecutor;
import org.wildfly.common.function.ExceptionSupplier;

public class CommandDispatcherTransport
extends AbstractRemoteTransport<Node>
implements GroupListener {
    private final ServiceExecutor executor = new StampedLockServiceExecutor();
    private final CommandDispatcherFactory dispatcherFactory;
    private final String name;
    private volatile CommandDispatcher<CommandDispatcherTransport> dispatcher;
    private volatile Registration groupListenerRegistration;
    private volatile boolean initialized = false;

    public CommandDispatcherTransport(CommandDispatcherFactory dispatcherFactory, String name) {
        this.dispatcherFactory = dispatcherFactory;
        this.name = name;
    }

    public String getId() {
        return this.getOwnAddress().getName();
    }

    public void startup() throws Exception {
        this.dispatcher = this.dispatcherFactory.createCommandDispatcher((Object)this.name, (Object)this);
        this.groupListenerRegistration = this.dispatcherFactory.getGroup().register((Object)this);
        this.broadcast(new JoinCommand());
    }

    public void shutdown() {
        this.executor.close(() -> {
            try {
                this.broadcast(new LeaveCommand(this.getOwnAddress()));
            }
            catch (WorkException e) {
                ConnectorLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
            }
            finally {
                this.groupListenerRegistration.close();
                this.dispatcher.close();
            }
        });
    }

    public void initialize() throws Exception {
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected Node getOwnAddress() {
        return this.dispatcherFactory.getGroup().getLocalMember();
    }

    protected Serializable sendMessage(Node physicalAddress, ProtocolMessages.Request request, Serializable ... parameters) throws WorkException {
        Command<?, CommandDispatcherTransport> command = CommandDispatcherTransport.createCommand(request, parameters);
        ExceptionSupplier task = () -> this.dispatcher.executeOnNode(command, physicalAddress);
        try {
            CommandResponse response = this.executor.execute(task).orElse(null);
            return response != null ? (Serializable)response.get() : null;
        }
        catch (ExecutionException | CommandDispatcherException e) {
            throw new WorkException(e);
        }
    }

    private void broadcast(Command<Void, CommandDispatcherTransport> command) throws WorkException {
        ExceptionSupplier task = () -> this.dispatcher.executeOnCluster(command, new Node[0]);
        try {
            Map responses = this.executor.execute(task).orElse(Collections.emptyMap());
            for (Map.Entry entry : responses.entrySet()) {
                ((CommandResponse)entry.getValue()).get();
            }
        }
        catch (ExecutionException | CommandDispatcherException e) {
            throw new WorkException(e);
        }
    }

    private static Command<?, CommandDispatcherTransport> createCommand(ProtocolMessages.Request request, Serializable ... parameters) {
        Address address = parameters.length > 0 ? (Address)parameters[0] : null;
        switch (request) {
            case CLEAR_DISTRIBUTED_STATISTICS: {
                return new ClearDistributedStatisticsCommand(address);
            }
            case DELTA_DOWORK_ACCEPTED: {
                return new DeltaDoWorkAcceptedCommand(address);
            }
            case DELTA_DOWORK_REJECTED: {
                return new DeltaDoWorkRejectedCommand(address);
            }
            case DELTA_SCHEDULEWORK_ACCEPTED: {
                return new DeltaScheduleWorkAcceptedCommand(address);
            }
            case DELTA_SCHEDULEWORK_REJECTED: {
                return new DeltaScheduleWorkRejectedCommand(address);
            }
            case DELTA_STARTWORK_ACCEPTED: {
                return new DeltaStartWorkAcceptedCommand(address);
            }
            case DELTA_STARTWORK_REJECTED: {
                return new DeltaStartWorkRejectedCommand(address);
            }
            case DELTA_WORK_FAILED: {
                return new DeltaWorkFailedCommand(address);
            }
            case DELTA_WORK_SUCCESSFUL: {
                return new DeltaWorkSuccessfulCommand(address);
            }
            case DO_WORK: {
                return new DoWorkCommand(address, (DistributableWork)parameters[2]);
            }
            case GET_DISTRIBUTED_STATISTICS: {
                return new DistributedStatisticsCommand(address);
            }
            case GET_LONGRUNNING_FREE: {
                return new LongRunningFreeCommand(address);
            }
            case GET_SHORTRUNNING_FREE: {
                return new ShortRunningFreeCommand(address);
            }
            case PING: {
                return new PingCommand();
            }
            case SCHEDULE_WORK: {
                return new ScheduleWorkCommand(address, (DistributableWork)parameters[2]);
            }
            case START_WORK: {
                return new StartWorkCommand(address, (DistributableWork)parameters[2]);
            }
            case UPDATE_LONGRUNNING_FREE: {
                return new UpdateLongRunningFreeCommand(address, (Long)parameters[1]);
            }
            case UPDATE_SHORTRUNNING_FREE: {
                return new UpdateShortRunningFreeCommand(address, (Long)parameters[1]);
            }
            case WORKMANAGER_ADD: {
                return new AddWorkManagerCommand(address, (Node)parameters[1]);
            }
            case WORKMANAGER_REMOVE: {
                return new RemoveWorkManagerCommand(address);
            }
        }
        throw new IllegalStateException(request.name());
    }

    public void membershipChanged(Membership previousMembership, Membership membership, boolean merged) {
        Runnable task = () -> {
            HashSet leavers = new HashSet(previousMembership.getMembers());
            leavers.removeAll(membership.getMembers());
            for (Node leaver : leavers) {
                this.leave(leaver);
            }
            if (merged) {
                this.join(membership);
            }
        };
        this.executor.execute(task);
    }

    public void join() {
        this.join(this.dispatcherFactory.getGroup().getMembership());
    }

    private void join(Membership membership) {
        HashMap<Node, Future> futures = new HashMap<Node, Future>();
        for (Node node : membership.getMembers()) {
            if (this.getOwnAddress().equals(node) || this.nodes.containsValue(node)) continue;
            try {
                futures.put(node, this.dispatcher.submitOnNode((Command)new GetWorkManagersCommand(), node));
            }
            catch (CommandDispatcherException e) {
                ConnectorLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
            }
        }
        try {
            for (Map.Entry entry : futures.entrySet()) {
                Node member = (Node)entry.getKey();
                try {
                    Set addresses = (Set)((Future)entry.getValue()).get();
                    for (Address address : addresses) {
                        this.join(address, member);
                        this.localUpdateLongRunningFree(address, this.getShortRunningFree(address));
                        this.localUpdateShortRunningFree(address, this.getShortRunningFree(address));
                    }
                }
                catch (ExecutionException e) {
                    ConnectorLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

