/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.WeldProvider;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.ModuleGroupSingletonProvider;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.Container;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldStartService
implements Service<WeldStartService> {
    public static final ServiceName SERVICE_NAME = ServiceNames.WELD_START_SERVICE_NAME;
    private final InjectedValue<WeldBootstrapService> bootstrap = new InjectedValue();
    private final List<SetupAction> setupActions;
    private final ClassLoader classLoader;
    private final ServiceName deploymentServiceName;
    private final AtomicBoolean runOnce = new AtomicBoolean();

    public WeldStartService(List<SetupAction> setupActions, ClassLoader classLoader, ServiceName deploymentServiceName) {
        this.setupActions = setupActions;
        this.classLoader = classLoader;
        this.deploymentServiceName = deploymentServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        if (this.runOnce.get()) {
            ServiceController controller = context.getController().getServiceContainer().getService(this.deploymentServiceName);
            controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                    if (transition.getAfter().equals((Object)ServiceController.Substate.DOWN)) {
                        controller.setMode(ServiceController.Mode.ACTIVE);
                        controller.removeListener((ServiceListener)this);
                    }
                }
            });
            controller.setMode(ServiceController.Mode.NEVER);
            return;
        }
        this.runOnce.set(true);
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            for (SetupAction action : this.setupActions) {
                action.setup(null);
            }
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            ((WeldBootstrapService)this.bootstrap.getValue()).getBootstrap().startInitialization();
            ((WeldBootstrapService)this.bootstrap.getValue()).getBootstrap().deployBeans();
            ((WeldBootstrapService)this.bootstrap.getValue()).getBootstrap().validateBeans();
        }
        finally {
            for (SetupAction action : this.setupActions) {
                try {
                    action.teardown(null);
                }
                catch (Exception e) {
                    WeldLogger.DEPLOYMENT_LOGGER.exceptionClearingThreadState(e);
                }
            }
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        WeldBootstrapService bootstrapService = (WeldBootstrapService)this.bootstrap.getValue();
        if (!bootstrapService.isStarted()) {
            throw WeldLogger.ROOT_LOGGER.notStarted("WeldContainer");
        }
        WeldLogger.DEPLOYMENT_LOGGER.stoppingWeldService(bootstrapService.getDeploymentName());
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)bootstrapService.getDeployment().getModule().getClassLoader());
            WeldProvider.containerShutDown(Container.instance((String)bootstrapService.getDeploymentName()));
            bootstrapService.getBootstrap().shutdown();
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
            ModuleGroupSingletonProvider.removeClassLoader((ClassLoader)bootstrapService.getDeployment().getModule().getClassLoader());
        }
        bootstrapService.setStarted(false);
    }

    public WeldStartService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<WeldBootstrapService> getBootstrap() {
        return this.bootstrap;
    }
}

