/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.CachingModifiableSecurityRealm;
import org.wildfly.security.auth.realm.CachingSecurityRealm;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.cache.LRURealmIdentityCache;
import org.wildfly.security.cache.RealmIdentityCache;

class CachingRealmDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, "caching-realm", SecurityRealm.class);
    static final SimpleAttributeDefinition REALM_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, false).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-realm")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MAXIMUM_ENTRIES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-entries", ModelType.INT, true).setDefaultValue(new ModelNode(16))).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MAXIMUM_AGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-age", ModelType.LONG, true).setDefaultValue(new ModelNode(-1L))).setMinSize(1)).setRestartAllServices()).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{REALM_NAME, MAXIMUM_ENTRIES, MAXIMUM_AGE};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    CachingRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"caching-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("caching-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler write = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ClearCacheHandler.register(resourceRegistration, this.getResourceDescriptionResolver());
    }

    private static class ClearCacheHandler
    extends ElytronRuntimeOnlyHandler {
        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("clear-cache", descriptionResolver).setRuntimeOnly().build(), (OperationStepHandler)new ClearCacheHandler());
        }

        private ClearCacheHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
            PathAddress currentAddress = context.getCurrentAddress();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(currentAddress.getLastElement().getValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName();
            ServiceController<SecurityRealm> serviceController = ElytronExtension.getRequiredService(serviceRegistry, realmName, SecurityRealm.class);
            CachingSecurityRealm securityRealm = (CachingSecurityRealm)CachingSecurityRealm.class.cast(serviceController.getValue());
            securityRealm.removeAllFromCache();
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            String cacheableRealm = REALM_NAME.resolveModelAttribute(context, model).asString();
            int maxEntries = MAXIMUM_ENTRIES.resolveModelAttribute(context, model).asInt();
            long maxAge = MAXIMUM_AGE.resolveModelAttribute(context, model).asInt();
            InjectedValue cacheableRealmValue = new InjectedValue();
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, this.createService(cacheableRealm, maxEntries, maxAge, (InjectedValue<SecurityRealm>)cacheableRealmValue));
            this.addRealmDependency(context, (ServiceBuilder<SecurityRealm>)serviceBuilder, cacheableRealm, (Injector<SecurityRealm>)cacheableRealmValue);
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private TrivialService<SecurityRealm> createService(String realmName, int maxEntries, long maxAge, InjectedValue<SecurityRealm> injector) {
            return new TrivialService<SecurityRealm>(() -> {
                SecurityRealm securityRealm = (SecurityRealm)injector.getValue();
                if (securityRealm instanceof CacheableSecurityRealm) {
                    LRURealmIdentityCache cache = this.createRealmIdentityCache(maxEntries, maxAge);
                    CacheableSecurityRealm cacheableRealm = (CacheableSecurityRealm)CacheableSecurityRealm.class.cast(securityRealm);
                    if (securityRealm instanceof ModifiableSecurityRealm) {
                        return new CachingModifiableSecurityRealm(cacheableRealm, (RealmIdentityCache)cache);
                    }
                    return new CachingSecurityRealm(cacheableRealm, (RealmIdentityCache)cache);
                }
                throw ElytronSubsystemMessages.ROOT_LOGGER.realmDoesNotSupportCache(realmName);
            });
        }

        private LRURealmIdentityCache createRealmIdentityCache(int maxEntries, long maxAge) {
            return new LRURealmIdentityCache(maxEntries, maxAge);
        }

        private void addRealmDependency(OperationContext context, ServiceBuilder<SecurityRealm> serviceBuilder, String realmName, Injector<SecurityRealm> securityRealmInjector) {
            String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-realm", (String)realmName);
            ServiceName realmServiceName = context.getCapabilityServiceName(runtimeCapability, SecurityRealm.class);
            REALM_SERVICE_UTIL.addInjection(serviceBuilder, securityRealmInjector, realmServiceName);
        }
    }
}

