/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.x500.X500Principal;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.CertificateChainAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.KeyStoreService;
import org.wildfly.extension.elytron.ModifiableKeyStoreDecorator;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.x500.X500;
import org.wildfly.security.x500.cert.PKCS10CertificateSigningRequest;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;

class AdvancedModifiableKeyStoreDecorator
extends ModifiableKeyStoreDecorator {
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static final DateTimeFormatter NOT_VALID_BEFORE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    static final SimpleAttributeDefinition ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias", ModelType.STRING).setAllowExpression(true)).setMinSize(1)).build();
    static final SimpleAttributeDefinition SIGNATURE_ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("signature-algorithm", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).build();
    static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setAllowExpression(true)).setMinSize(1)).build();
    static final SimpleAttributeDefinition CRITICAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("critical", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    static final SimpleAttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.STRING).setAllowExpression(true)).setMinSize(1)).build();
    static final ObjectTypeAttributeDefinition EXTENSION = new ObjectTypeAttributeDefinition.Builder("extension", new AttributeDefinition[]{NAME, CRITICAL, VALUE}).build();
    static final ObjectListAttributeDefinition EXTENSIONS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("extensions", EXTENSION).setRequired(false)).setAllowDuplicates(false)).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = CredentialReference.getAttributeBuilder((boolean)true, (boolean)true).build();
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(FileAttributeDefinitions.PATH).setRequired(true)).build();

    static ResourceDefinition wrap(ResourceDefinition resourceDefinition) {
        return new AdvancedModifiableKeyStoreDecorator(resourceDefinition);
    }

    private AdvancedModifiableKeyStoreDecorator(ResourceDefinition resourceDefinition) {
        super(resourceDefinition);
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        StandardResourceDescriptionResolver resolver = ElytronExtension.getResourceDescriptionResolver("modifiable-key-store");
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            GenerateKeyPairHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
            GenerateCertificateSigningRequestHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
            ImportCertificateHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
            ExportCertificateHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
            ChangeAliasHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        }
    }

    private static char[] resolveKeyPassword(KeyStoreService keyStoreService, ExceptionSupplier<CredentialSource, Exception> credentialSourceSupplier) throws RuntimeException {
        try {
            return keyStoreService.resolveKeyPassword(credentialSourceSupplier);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class NotBeforeValidator
    extends StringLengthValidator {
        NotBeforeValidator() {
            super(1, true, true);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined()) {
                try {
                    NOT_VALID_BEFORE_FORMATTER.parse(value.asString());
                }
                catch (DateTimeParseException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidNotBefore(e, e.getLocalizedMessage());
                }
            }
        }
    }

    static class ChangeAliasHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition NEW_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("new-alias", ModelType.STRING).setAllowExpression(true)).setMinSize(1)).build();

        ChangeAliasHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("change-alias", descriptionResolver).setParameters(new AttributeDefinition[]{ALIAS, NEW_ALIAS, CREDENTIAL_REFERENCE}).setRuntimeOnly().build(), (OperationStepHandler)new ChangeAliasHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModifiableKeyStoreService keyStoreService = ModifiableKeyStoreDecorator.getModifiableKeyStoreService(context);
            KeyStore keyStore = keyStoreService.getModifiableValue();
            String alias = ALIAS.resolveModelAttribute(context, operation).asString();
            String newAlias = NEW_ALIAS.resolveModelAttribute(context, operation).asString();
            ExceptionSupplier credentialSourceSupplier = null;
            if (CREDENTIAL_REFERENCE.resolveModelAttribute(context, operation).isDefined()) {
                credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)operation, null);
            }
            char[] keyPassword = AdvancedModifiableKeyStoreDecorator.resolveKeyPassword((KeyStoreService)keyStoreService, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceSupplier);
            try {
                KeyStore.Entry entry;
                if (!keyStore.containsAlias(alias)) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.keyStoreAliasDoesNotExist(alias);
                }
                if (keyStore.containsAlias(newAlias)) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.keyStoreAliasAlreadyExists(newAlias);
                }
                KeyStore.PasswordProtection passwordProtection = null;
                try {
                    entry = keyStore.getEntry(alias, passwordProtection);
                }
                catch (UnrecoverableEntryException e) {
                    passwordProtection = new KeyStore.PasswordProtection(keyPassword);
                    try {
                        entry = keyStore.getEntry(alias, passwordProtection);
                    }
                    catch (UnrecoverableEntryException ex) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainEntry(alias);
                    }
                }
                if (entry == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainEntry(alias);
                }
                keyStore.setEntry(newAlias, entry, passwordProtection);
                if (keyStore.containsAlias(alias)) {
                    keyStore.deleteEntry(alias);
                }
            }
            catch (Exception e) {
                if (e instanceof OperationFailedException) {
                    throw (OperationFailedException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    static class ExportCertificateHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition PEM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pem", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();

        ExportCertificateHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("export-certificate", descriptionResolver).setParameters(new AttributeDefinition[]{ALIAS, PATH, FileAttributeDefinitions.RELATIVE_TO, PEM}).setRuntimeOnly().build(), (OperationStepHandler)new ExportCertificateHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModifiableKeyStoreService keyStoreService = ModifiableKeyStoreDecorator.getModifiableKeyStoreService(context);
            KeyStore keyStore = keyStoreService.getModifiableValue();
            String alias = ALIAS.resolveModelAttribute(context, operation).asString();
            String path = PATH.resolveModelAttribute(context, operation).asString();
            String relativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, operation).asStringOrNull();
            FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
            File resolvedPath = ((KeyStoreService)keyStoreService).getResolvedPath(pathResolver, path, relativeTo);
            boolean pem = PEM.resolveModelAttribute(context, operation).asBoolean();
            try {
                if (!keyStore.containsAlias(alias)) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.keyStoreAliasDoesNotExist(alias);
                }
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                if (certificate == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainCertificate(alias);
                }
                try (FileOutputStream fos = new FileOutputStream(resolvedPath);){
                    if (pem) {
                        ByteStringBuilder pemCertificate = new ByteStringBuilder();
                        Pem.generatePemX509Certificate((ByteStringBuilder)pemCertificate, (X509Certificate)certificate);
                        fos.write(pemCertificate.toArray());
                    } else {
                        fos.write(certificate.getEncoded());
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof OperationFailedException) {
                    throw (OperationFailedException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    static class ImportCertificateHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition TRUST_CACERTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("trust-cacerts", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
        static final SimpleAttributeDefinition VALIDATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("validate", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();

        ImportCertificateHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("import-certificate", descriptionResolver).setParameters(new AttributeDefinition[]{ALIAS, CREDENTIAL_REFERENCE, PATH, FileAttributeDefinitions.RELATIVE_TO, TRUST_CACERTS, VALIDATE}).setRuntimeOnly().build(), (OperationStepHandler)new ImportCertificateHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            block52: {
                ModifiableKeyStoreService keyStoreService = ModifiableKeyStoreDecorator.getModifiableKeyStoreService(context);
                KeyStore keyStore = keyStoreService.getModifiableValue();
                String alias = ALIAS.resolveModelAttribute(context, operation).asString();
                ExceptionSupplier credentialSourceSupplier = null;
                if (CREDENTIAL_REFERENCE.resolveModelAttribute(context, operation).isDefined()) {
                    credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)operation, null);
                }
                char[] keyPassword = AdvancedModifiableKeyStoreDecorator.resolveKeyPassword((KeyStoreService)keyStoreService, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceSupplier);
                String path = PATH.resolveModelAttribute(context, operation).asString();
                String relativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, operation).asStringOrNull();
                FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                File resolvedPath = ((KeyStoreService)keyStoreService).getResolvedPath(pathResolver, path, relativeTo);
                boolean trustCacerts = TRUST_CACERTS.resolveModelAttribute(context, operation).asBoolean();
                boolean validate = VALIDATE.resolveModelAttribute(context, operation).asBoolean();
                try {
                    X509Certificate trustedCertificate;
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    if (keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                        Certificate[] certificateChain;
                        Collection<? extends Certificate> reply;
                        PrivateKey privateKey;
                        try {
                            privateKey = (PrivateKey)keyStore.getKey(alias, keyPassword);
                        }
                        catch (UnrecoverableKeyException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainPrivateKey(alias);
                        }
                        if (privateKey == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainPrivateKey(alias);
                        }
                        Certificate certificate = keyStore.getCertificate(alias);
                        if (certificate == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainCertificate(alias);
                        }
                        PublicKey publicKey = certificate.getPublicKey();
                        try (FileInputStream fis = new FileInputStream(resolvedPath);){
                            reply = certificateFactory.generateCertificates(fis);
                        }
                        catch (FileNotFoundException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.certificateFileDoesNotExist(e);
                        }
                        if (reply.isEmpty()) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.noCertificatesFoundInCertificateReply();
                        }
                        Certificate[] replyCertificates = reply.toArray(new Certificate[reply.size()]);
                        if (replyCertificates.length == 1) {
                            X509Certificate replyCertificate = (X509Certificate)replyCertificates[0];
                            if (!replyCertificate.getPublicKey().equals(publicKey)) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.publicKeyFromCertificateReplyDoesNotMatchKeyStore();
                            }
                            if (replyCertificate.equals(certificate)) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.certificateReplySameAsCertificateFromKeyStore();
                            }
                            HashMap<Principal, HashSet<X509Certificate>> certificatesMap = ImportCertificateHandler.getKeyStoreCertificates(keyStore, ImportCertificateHandler.getCacertsKeyStore(trustCacerts));
                            certificateChain = X500.createX509CertificateChain((X509Certificate)replyCertificate, certificatesMap);
                        } else {
                            certificateChain = X500.asOrderedX509CertificateChain((PublicKey)publicKey, (Certificate[])replyCertificates);
                            if (validate) {
                                X509Certificate lastCertificate = certificateChain[certificateChain.length - 1];
                                X509Certificate certificateOrIssuer = ImportCertificateHandler.getCertificateOrIssuerFromKeyStores(lastCertificate, keyStore, ImportCertificateHandler.getCacertsKeyStore(trustCacerts));
                                if (certificateOrIssuer == null) {
                                    CertificateChainAttributeDefinitions.writeCertificate(context.getResult().get("certificate"), lastCertificate);
                                    throw ElytronSubsystemMessages.ROOT_LOGGER.topMostCertificateFromCertificateReplyNotTrusted();
                                }
                                if (!lastCertificate.equals(certificateOrIssuer)) {
                                    X509Certificate[] newCertificateChain = (X509Certificate[])Arrays.copyOf(certificateChain, certificateChain.length + 1);
                                    newCertificateChain[newCertificateChain.length - 1] = certificateOrIssuer;
                                    certificateChain = newCertificateChain;
                                }
                            }
                        }
                        keyStore.setKeyEntry(alias, privateKey, keyPassword, certificateChain);
                        break block52;
                    }
                    if (keyStore.containsAlias(alias)) break block52;
                    try (FileInputStream fis = new FileInputStream(resolvedPath);){
                        trustedCertificate = (X509Certificate)certificateFactory.generateCertificate(fis);
                    }
                    catch (FileNotFoundException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.certificateFileDoesNotExist(e);
                    }
                    if (validate) {
                        String trustedCertificateAlias = keyStore.getCertificateAlias(trustedCertificate);
                        if (trustedCertificateAlias != null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.trustedCertificateAlreadyInKeyStore(trustedCertificateAlias);
                        }
                        KeyStore cacertsKeyStore = ImportCertificateHandler.getCacertsKeyStore(trustCacerts);
                        if (trustedCertificate.getIssuerDN().equals(trustedCertificate.getSubjectDN())) {
                            trustedCertificate.verify(trustedCertificate.getPublicKey());
                            if (cacertsKeyStore != null && (trustedCertificateAlias = cacertsKeyStore.getCertificateAlias(trustedCertificate)) != null) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.trustedCertificateAlreadyInCacertsKeyStore(trustedCertificateAlias);
                            }
                            CertificateChainAttributeDefinitions.writeCertificate(context.getResult().get("certificate"), trustedCertificate);
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToDetermineIfCertificateIsTrusted();
                        }
                        try {
                            HashMap<Principal, HashSet<X509Certificate>> certificatesMap = ImportCertificateHandler.getKeyStoreCertificates(keyStore, cacertsKeyStore);
                            X500.createX509CertificateChain((X509Certificate)trustedCertificate, certificatesMap);
                        }
                        catch (IllegalArgumentException e) {
                            CertificateChainAttributeDefinitions.writeCertificate(context.getResult().get("certificate"), trustedCertificate);
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToDetermineIfCertificateIsTrusted();
                        }
                    }
                    keyStore.setCertificateEntry(alias, trustedCertificate);
                }
                catch (Exception e) {
                    if (e instanceof OperationFailedException) {
                        throw (OperationFailedException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        }

        private static KeyStore getCacertsKeyStore(boolean trustCacerts) throws Exception {
            KeyStore cacertsKeyStore = null;
            if (trustCacerts) {
                File cacertsFile = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
                try (FileInputStream fis = new FileInputStream(cacertsFile);){
                    cacertsKeyStore = KeyStore.getInstance("JKS");
                    cacertsKeyStore.load(fis, null);
                }
            }
            return cacertsKeyStore;
        }

        private static HashMap<Principal, HashSet<X509Certificate>> getKeyStoreCertificates(KeyStore ... keyStores) throws KeyStoreException {
            HashMap<Principal, HashSet<X509Certificate>> certificatesMap = new HashMap<Principal, HashSet<X509Certificate>>();
            for (KeyStore keyStore : keyStores) {
                if (keyStore == null) continue;
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate certificate = keyStore.getCertificate(alias);
                    if (certificate == null || !(certificate instanceof X509Certificate)) continue;
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    HashSet<X509Certificate> principalCertificates = certificatesMap.get(x509Certificate.getSubjectDN());
                    if (principalCertificates == null) {
                        principalCertificates = new HashSet();
                        certificatesMap.put(x509Certificate.getSubjectDN(), principalCertificates);
                    }
                    principalCertificates.add(x509Certificate);
                }
            }
            return certificatesMap;
        }

        private static X509Certificate getCertificateOrIssuerFromKeyStores(X509Certificate certificate, KeyStore ... keyStores) throws KeyStoreException {
            for (KeyStore keyStore : keyStores) {
                if (keyStore == null) continue;
                if (keyStore.getCertificateAlias(certificate) != null) {
                    return certificate;
                }
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate x509IssuerCertificate;
                    String alias = aliases.nextElement();
                    Certificate issuerCertificate = keyStore.getCertificate(alias);
                    if (issuerCertificate == null || !(issuerCertificate instanceof X509Certificate) || !(x509IssuerCertificate = (X509Certificate)issuerCertificate).getSubjectDN().equals(certificate.getIssuerDN())) continue;
                    try {
                        certificate.verify(x509IssuerCertificate.getPublicKey());
                        return x509IssuerCertificate;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            return null;
        }
    }

    static class GenerateCertificateSigningRequestHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition DISTINGUISHED_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("distinguished-name", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).build();

        GenerateCertificateSigningRequestHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("generate-certificate-signing-request", descriptionResolver).setParameters(new AttributeDefinition[]{ALIAS, SIGNATURE_ALGORITHM, DISTINGUISHED_NAME, EXTENSIONS, CREDENTIAL_REFERENCE, PATH, FileAttributeDefinitions.RELATIVE_TO}).setRuntimeOnly().build(), (OperationStepHandler)new GenerateCertificateSigningRequestHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModifiableKeyStoreService keyStoreService = ModifiableKeyStoreDecorator.getModifiableKeyStoreService(context);
            KeyStore keyStore = keyStoreService.getModifiableValue();
            String alias = ALIAS.resolveModelAttribute(context, operation).asString();
            String signatureAlgorithm = SIGNATURE_ALGORITHM.resolveModelAttribute(context, operation).asStringOrNull();
            String distinguishedName = DISTINGUISHED_NAME.resolveModelAttribute(context, operation).asStringOrNull();
            ModelNode extensions = EXTENSIONS.resolveModelAttribute(context, operation);
            ExceptionSupplier credentialSourceSupplier = null;
            if (CREDENTIAL_REFERENCE.resolveModelAttribute(context, operation).isDefined()) {
                credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)operation, null);
            }
            char[] keyPassword = AdvancedModifiableKeyStoreDecorator.resolveKeyPassword((KeyStoreService)keyStoreService, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceSupplier);
            String path = PATH.resolveModelAttribute(context, operation).asString();
            String relativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, operation).asStringOrNull();
            FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
            File resolvedPath = ((KeyStoreService)keyStoreService).getResolvedPath(pathResolver, path, relativeTo);
            try {
                PrivateKey privateKey;
                if (!keyStore.containsAlias(alias)) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.keyStoreAliasDoesNotExist(alias);
                }
                if (!keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.keyStoreAliasDoesNotIdentifyPrivateKeyEntry(alias);
                }
                try {
                    privateKey = (PrivateKey)keyStore.getKey(alias, keyPassword);
                }
                catch (UnrecoverableKeyException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainPrivateKey(alias);
                }
                if (privateKey == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainPrivateKey(alias);
                }
                Certificate certificate = keyStore.getCertificate(alias);
                if (certificate == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainCertificate(alias);
                }
                PKCS10CertificateSigningRequest.Builder csrBuilder = PKCS10CertificateSigningRequest.builder();
                csrBuilder.setSigningKey(privateKey);
                csrBuilder.setCertificate(certificate);
                if (signatureAlgorithm != null) {
                    csrBuilder.setSignatureAlgorithmName(signatureAlgorithm);
                }
                if (distinguishedName != null) {
                    csrBuilder.setSubjectDn(new X500Principal(distinguishedName));
                }
                if (extensions.isDefined()) {
                    for (ModelNode extension : extensions.asList()) {
                        Boolean critical = CRITICAL.resolveModelAttribute(context, extension).asBoolean();
                        String extensionName = NAME.resolveModelAttribute(context, extension).asString();
                        String extensionValue = VALUE.resolveModelAttribute(context, extension).asString();
                        csrBuilder.addExtension(critical.booleanValue(), extensionName, extensionValue);
                    }
                }
                PKCS10CertificateSigningRequest csr = csrBuilder.build();
                try (FileOutputStream fos = new FileOutputStream(resolvedPath);){
                    fos.write(csr.getPem());
                }
            }
            catch (Exception e) {
                if (e instanceof OperationFailedException) {
                    throw (OperationFailedException)e;
                }
                if (e instanceof IllegalArgumentException) {
                    throw new OperationFailedException((Throwable)e);
                }
                throw new RuntimeException(e);
            }
        }
    }

    static class GenerateKeyPairHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).build();
        static final SimpleAttributeDefinition KEY_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-size", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
        static final SimpleAttributeDefinition DISTINGUISHED_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("distinguished-name", ModelType.STRING).setAllowExpression(true)).setMinSize(1)).build();
        static final SimpleAttributeDefinition NOT_BEFORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("not-before", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new NotBeforeValidator())).build();
        static final SimpleAttributeDefinition VALIDITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("validity", ModelType.LONG, true).setAllowExpression(true)).setValidator((ParameterValidator)new LongRangeValidator(1L))).setDefaultValue(new ModelNode(90))).build();

        GenerateKeyPairHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("generate-key-pair", descriptionResolver).setParameters(new AttributeDefinition[]{ALIAS, ALGORITHM, SIGNATURE_ALGORITHM, KEY_SIZE, DISTINGUISHED_NAME, NOT_BEFORE, VALIDITY, EXTENSIONS, CREDENTIAL_REFERENCE}).setRuntimeOnly().build(), (OperationStepHandler)new GenerateKeyPairHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModifiableKeyStoreService keyStoreService = ModifiableKeyStoreDecorator.getModifiableKeyStoreService(context);
            KeyStore keyStore = keyStoreService.getModifiableValue();
            String alias = ALIAS.resolveModelAttribute(context, operation).asString();
            String algorithm = ALGORITHM.resolveModelAttribute(context, operation).asStringOrNull();
            String signatureAlgorithm = SIGNATURE_ALGORITHM.resolveModelAttribute(context, operation).asStringOrNull();
            Integer keySize = KEY_SIZE.resolveModelAttribute(context, operation).asIntOrNull();
            String distinguishedName = DISTINGUISHED_NAME.resolveModelAttribute(context, operation).asString();
            String notBefore = NOT_BEFORE.resolveModelAttribute(context, operation).asStringOrNull();
            Long validity = VALIDITY.resolveModelAttribute(context, operation).asLong();
            ModelNode extensions = EXTENSIONS.resolveModelAttribute(context, operation);
            ExceptionSupplier credentialSourceSupplier = null;
            if (CREDENTIAL_REFERENCE.resolveModelAttribute(context, operation).isDefined()) {
                credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)operation, null);
            }
            char[] keyPassword = AdvancedModifiableKeyStoreDecorator.resolveKeyPassword((KeyStoreService)keyStoreService, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceSupplier);
            try {
                if (keyStore.containsAlias(alias)) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.keyStoreAliasAlreadyExists(alias);
                }
                SelfSignedX509CertificateAndSigningKey.Builder certAndKeyBuilder = SelfSignedX509CertificateAndSigningKey.builder();
                certAndKeyBuilder.setDn(new X500Principal(distinguishedName));
                if (algorithm != null) {
                    certAndKeyBuilder.setKeyAlgorithmName(algorithm);
                }
                if (signatureAlgorithm != null) {
                    certAndKeyBuilder.setSignatureAlgorithmName(signatureAlgorithm);
                }
                if (keySize != null) {
                    certAndKeyBuilder.setKeySize(keySize.intValue());
                }
                ZonedDateTime notBeforeDateTime = notBefore != null ? ZonedDateTime.from(NOT_VALID_BEFORE_FORMATTER.parse(notBefore)) : ZonedDateTime.now();
                certAndKeyBuilder.setNotValidBefore(notBeforeDateTime);
                certAndKeyBuilder.setNotValidAfter(notBeforeDateTime.plusDays(validity));
                if (extensions.isDefined()) {
                    for (ModelNode extension : extensions.asList()) {
                        Boolean critical = CRITICAL.resolveModelAttribute(context, extension).asBoolean();
                        String extensionName = NAME.resolveModelAttribute(context, extension).asString();
                        String extensionValue = VALUE.resolveModelAttribute(context, extension).asString();
                        certAndKeyBuilder.addExtension(critical.booleanValue(), extensionName, extensionValue);
                    }
                }
                SelfSignedX509CertificateAndSigningKey certAndKey = certAndKeyBuilder.build();
                PrivateKey privateKey = certAndKey.getSigningKey();
                Certificate[] certChain = new X509Certificate[]{certAndKey.getSelfSignedCertificate()};
                keyStore.setKeyEntry(alias, privateKey, keyPassword, certChain);
            }
            catch (IllegalArgumentException e) {
                throw new OperationFailedException((Throwable)e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

