/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gs2;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.sasl.WildFlySasl;
import org.wildfly.security.sasl.gs2.Gs2SaslServer;
import org.wildfly.security.sasl.gs2.Gs2Util;

public final class Gs2SaslServerFactory
implements SaslServerFactory {
    private final GSSManager gssManager;

    public Gs2SaslServerFactory(GSSManager gssManager) {
        this.gssManager = gssManager;
    }

    public Gs2SaslServerFactory() {
        this(GSSManager.getInstance());
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        boolean bindingRequired;
        String[] supportedMechs;
        Assert.checkNotNullParam("cbh", cbh);
        GSSManager gssManager = this.gssManager;
        try {
            supportedMechs = Gs2Util.getSupportedSaslNamesForMechanisms(gssManager.getMechs());
        }
        catch (GSSException e) {
            throw ElytronMessages.saslGs2.mechGettingSupportedMechanismsFailed(e).toSaslException();
        }
        if (!Gs2Util.isIncluded(mechanism, supportedMechs)) {
            return null;
        }
        boolean plus = false;
        ChannelBindingCallback channelBindingCallback = new ChannelBindingCallback();
        try {
            cbh.handle(new Callback[]{channelBindingCallback});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.saslGs2.mechFailedToDetermineChannelBindingStatus(e).toSaslException();
        }
        catch (UnsupportedCallbackException e) {
            // empty catch block
        }
        String bindingType = channelBindingCallback.getBindingType();
        byte[] bindingData = channelBindingCallback.getBindingData();
        boolean bindingOk = bindingType != null && bindingData != null;
        boolean bl = bindingRequired = props != null && "true".equals(props.get("wildfly.sasl.channel-binding-required"));
        if (mechanism.endsWith("-PLUS")) {
            if (!bindingOk) {
                return null;
            }
            plus = true;
        }
        if (bindingRequired && !plus) {
            return null;
        }
        Gs2SaslServer server = new Gs2SaslServer(mechanism, protocol, serverName, cbh, gssManager, plus, bindingType, bindingData);
        server.init();
        return server;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        String[] names;
        try {
            names = Gs2Util.getSupportedSaslNamesForMechanisms(this.gssManager.getMechs());
        }
        catch (GSSException e) {
            return WildFlySasl.NO_NAMES;
        }
        if (props != null && !"true".equals(props.get("wildfly.sasl.mechanism-query-all")) && "true".equals(props.get("wildfly.sasl.channel-binding-required"))) {
            return Gs2Util.getPlusMechanisms(names);
        }
        return names;
    }
}

