/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core.handlers;

import java.util.List;
import java.util.regex.Pattern;
import javax.xml.stream.Location;
import org.projectodd.vdx.core.ErrorHandler;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Position;
import org.projectodd.vdx.core.Util;
import org.projectodd.vdx.core.ValidationContext;
import org.projectodd.vdx.core.ValidationError;
import org.projectodd.vdx.core.schema.SchemaElement;

public class UnexpectedAttributeHandler
implements ErrorHandler {
    @Override
    public ErrorHandler.HandledResult handle(ValidationContext ctx, ValidationError error) {
        List<String> otherAttributes;
        Location loc = error.location();
        String attr = error.attribute().getLocalPart();
        String el = error.element().getLocalPart();
        Position pos = ctx.searchForward(loc.getLineNumber() - 1, loc.getColumnNumber(), Pattern.compile(attr + "\\s*="));
        List<List<SchemaElement>> altElements = ctx.alternateElementsForAttribute(attr);
        ErrorHandler.HandledResult result = ErrorHandler.HandledResult.from(error).addPrimaryMessage(I18N.Key.ATTRIBUTE_NOT_ALLOWED, attr, el);
        if (pos != null) {
            result.line(pos.line).column(pos.col);
        }
        if (error.alternatives().isEmpty()) {
            List<SchemaElement> schemaPath = ctx.mapDocLocationToSchemaPath(error.element(), error.position());
            if (schemaPath.isEmpty()) {
                result.possiblyMalformed(true);
            }
            otherAttributes = Util.asSortedList(ctx.attributesForElement(schemaPath));
        } else {
            otherAttributes = Util.asSortedList(error.alternatives());
        }
        if (!altElements.isEmpty()) {
            result.addSecondaryMessage(I18N.Key.ATTRIBUTE_IS_ALLOWED_ON, attr, altElements);
        }
        if (otherAttributes.isEmpty()) {
            result.addPrimaryMessage(I18N.Key.ELEMENT_HAS_NO_ATTRIBUTES, el);
        } else {
            String altSpelling = Util.alternateSpelling(attr, otherAttributes);
            if (altSpelling != null) {
                result.addPrimaryMessage(I18N.Key.DID_YOU_MEAN, altSpelling);
            }
            result.addPrimaryMessage(I18N.Key.ATTRIBUTES_ALLOWED_HERE, otherAttributes);
        }
        return result;
    }
}

