/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public abstract class DataSourceAbstractImpl
implements CommonDataSource {
    private static final long serialVersionUID = -5612846950298960159L;
    protected static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected TransactionIsolation transactionIsolation;
    protected TimeOut timeOut;
    protected DsSecurity security;
    protected Statement statement;
    protected Validation validation;
    protected String urlDelimiter;
    protected String urlSelectorStrategyClassName;
    protected Boolean useJavaContext;
    protected String poolName;
    protected Boolean enabled;
    protected String jndiName;
    protected Boolean spy;
    protected Boolean useCcm;
    protected String driver;
    protected String newConnectionSql;
    protected Boolean connectable;
    protected Boolean tracking;
    protected String mcp;
    protected Boolean enlistmentTrace;

    protected DataSourceAbstractImpl(TransactionIsolation transactionIsolation, TimeOut timeOut, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, Boolean useJavaContext, String poolName, Boolean enabled, String jndiName, Boolean spy, Boolean useCcm, String driver, String newConnectionSql, Boolean connectable, Boolean tracking, String mcp, Boolean enlistmentTrace) throws ValidateException {
        this.transactionIsolation = transactionIsolation;
        this.timeOut = timeOut;
        this.security = security;
        this.statement = statement;
        this.validation = validation;
        this.urlDelimiter = urlDelimiter;
        this.urlSelectorStrategyClassName = urlSelectorStrategyClassName;
        this.useJavaContext = useJavaContext;
        this.poolName = poolName;
        this.enabled = enabled;
        this.jndiName = jndiName;
        this.spy = spy;
        this.useCcm = useCcm;
        this.driver = driver;
        this.newConnectionSql = newConnectionSql;
        this.connectable = connectable;
        this.tracking = tracking;
        this.mcp = mcp;
        this.enlistmentTrace = enlistmentTrace;
        this.partialCommonValidation();
    }

    public TransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public TimeOut getTimeOut() {
        return this.timeOut;
    }

    public DsSecurity getSecurity() {
        return this.security;
    }

    public Validation getValidation() {
        return this.validation;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public String getUrlDelimiter() {
        return this.urlDelimiter;
    }

    public String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public Boolean isUseJavaContext() {
        return this.useJavaContext;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Boolean isSpy() {
        return this.spy;
    }

    public Boolean isUseCcm() {
        return this.useCcm;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getNewConnectionSql() {
        return this.newConnectionSql;
    }

    public Boolean isConnectable() {
        return this.connectable;
    }

    public Boolean isTracking() {
        return this.tracking;
    }

    public String getMcp() {
        return this.mcp;
    }

    public Boolean isEnlistmentTrace() {
        return this.enlistmentTrace;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    protected void partialCommonValidation() throws ValidateException {
        if (this.jndiName == null) {
            throw new ValidateException(bundle.requiredAttributeMissing(DataSource.Attribute.JNDI_NAME.getLocalName(), this.getClass().getCanonicalName()));
        }
        if (this.poolName == null) {
            throw new ValidateException(bundle.requiredAttributeMissing(DataSource.Attribute.POOL_NAME.getLocalName(), this.getClass().getCanonicalName()));
        }
        if (this.timeOut != null) {
            this.timeOut.validate();
        }
        if (this.security != null) {
            this.security.validate();
        }
        if (this.statement != null) {
            this.statement.validate();
        }
        if (this.validation != null) {
            this.validation.validate();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.jndiName == null ? 0 : this.jndiName.hashCode());
        result = 31 * result + (this.poolName == null ? 0 : this.poolName.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.statement == null ? 0 : this.statement.hashCode());
        result = 31 * result + (this.timeOut == null ? 0 : this.timeOut.hashCode());
        result = 31 * result + (this.transactionIsolation == null ? 0 : this.transactionIsolation.hashCode());
        result = 31 * result + (this.urlDelimiter == null ? 0 : this.urlDelimiter.hashCode());
        result = 31 * result + (this.urlSelectorStrategyClassName == null ? 0 : this.urlSelectorStrategyClassName.hashCode());
        result = 31 * result + (this.useJavaContext == null ? 0 : this.useJavaContext.hashCode());
        result = 31 * result + (this.validation == null ? 0 : this.validation.hashCode());
        result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 31 * result + (this.newConnectionSql == null ? 0 : this.newConnectionSql.hashCode());
        result = 31 * result + (this.connectable == null ? 0 : this.connectable.hashCode());
        result = 31 * result + (this.tracking == null ? 0 : this.tracking.hashCode());
        result = 31 * result + (this.mcp == null ? 0 : this.mcp.hashCode());
        result = 31 * result + (this.enlistmentTrace == null ? 0 : this.enlistmentTrace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceAbstractImpl)) {
            return false;
        }
        DataSourceAbstractImpl other = (DataSourceAbstractImpl)obj;
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.jndiName == null ? other.jndiName != null : !this.jndiName.equals(other.jndiName)) {
            return false;
        }
        if (this.poolName == null ? other.poolName != null : !this.poolName.equals(other.poolName)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.statement == null ? other.statement != null : !this.statement.equals(other.statement)) {
            return false;
        }
        if (this.timeOut == null ? other.timeOut != null : !this.timeOut.equals(other.timeOut)) {
            return false;
        }
        if (this.transactionIsolation != other.transactionIsolation) {
            return false;
        }
        if (this.urlDelimiter == null ? other.urlDelimiter != null : !this.urlDelimiter.equals(other.urlDelimiter)) {
            return false;
        }
        if (this.urlSelectorStrategyClassName == null ? other.urlSelectorStrategyClassName != null : !this.urlSelectorStrategyClassName.equals(other.urlSelectorStrategyClassName)) {
            return false;
        }
        if (this.useJavaContext == null ? other.useJavaContext != null : !this.useJavaContext.equals(other.useJavaContext)) {
            return false;
        }
        if (this.validation == null ? other.validation != null : !this.validation.equals(other.validation)) {
            return false;
        }
        if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
            return false;
        }
        if (this.newConnectionSql == null ? other.newConnectionSql != null : !this.newConnectionSql.equals(other.newConnectionSql)) {
            return false;
        }
        if (this.connectable == null ? other.connectable != null : !this.connectable.equals(other.connectable)) {
            return false;
        }
        if (this.tracking == null ? other.tracking != null : !this.tracking.equals(other.tracking)) {
            return false;
        }
        if (this.mcp == null ? other.mcp != null : !this.mcp.equals(other.mcp)) {
            return false;
        }
        return !(this.enlistmentTrace == null ? other.enlistmentTrace != null : !this.enlistmentTrace.equals(other.enlistmentTrace));
    }

    public abstract String toString();
}

