/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.util.concurrent.Executor;
import org.jboss.ejb._private.Logs;

class RetryExecutorWrapper {
    private final Object lock = new Object();
    private Task last = null;

    RetryExecutorWrapper() {
    }

    Executor getExecutor(Executor executor) {
        return runnable -> {
            Object object = this.lock;
            synchronized (object) {
                Task task = new Task(runnable, executor);
                if (this.last != null) {
                    this.last.next = task;
                    this.last = task;
                } else {
                    this.last = task;
                    executor.execute(task);
                }
            }
        };
    }

    private class Task
    implements Runnable {
        private final Runnable runnable;
        private final Executor delegate;
        private Task next;

        private Task(Runnable runnable, Executor delegate) {
            this.runnable = runnable;
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                Logs.MAIN.taskFailed(this.runnable, t);
            }
            finally {
                Object object = RetryExecutorWrapper.this.lock;
                synchronized (object) {
                    if (RetryExecutorWrapper.this.last == this) {
                        RetryExecutorWrapper.this.last = null;
                    }
                    if (this.next != null) {
                        this.next.delegate.execute(this.next);
                    }
                }
            }
        }
    }
}

