/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.CacheBuilderProvider;
import org.wildfly.clustering.spi.DistributedCacheBuilderProvider;
import org.wildfly.clustering.spi.ServiceNameRegistry;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorBuilder;
import org.wildfly.clustering.web.infinispan.session.RouteRegistryEntryProviderBuilder;
import org.wildfly.clustering.web.session.RouteLocator;
import org.wildfly.clustering.web.session.RouteLocatorBuilderProvider;

public class InfinispanRouteLocatorBuilderProvider
implements RouteLocatorBuilderProvider,
Consumer<ConfigurationBuilder> {
    public CapabilityServiceBuilder<RouteLocator> getRouteLocatorBuilder(String serverName, String deploymentName) {
        return new InfinispanRouteLocatorBuilder(serverName, deploymentName);
    }

    public Collection<CapabilityServiceBuilder<?>> getRouteLocatorConfigurationBuilders(String serverName, ValueDependency<String> routeDependency) {
        String containerName = "web";
        LinkedList builders = new LinkedList();
        builders.add(new RouteRegistryEntryProviderBuilder(serverName, routeDependency));
        builders.add((CapabilityServiceBuilder<?>)new TemplateConfigurationBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, serverName)), containerName, serverName, null, (Consumer)this));
        builders.add((CapabilityServiceBuilder<?>)new CacheBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(containerName, serverName)), containerName, serverName));
        ServiceNameRegistry registry = requirement -> ServiceName.parse((String)requirement.resolve(containerName, serverName));
        for (CacheBuilderProvider cacheBuilderProvider : ServiceLoader.load(DistributedCacheBuilderProvider.class, DistributedCacheBuilderProvider.class.getClassLoader())) {
            builders.addAll(cacheBuilderProvider.getBuilders(registry, containerName, serverName));
        }
        return builders;
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        ClusteringConfigurationBuilder clustering;
        CacheMode mode = (clustering = builder.clustering()).cacheMode();
        clustering.cacheMode(mode.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
        clustering.hash().consistentHashFactory(null);
        clustering.l1().disable();
        AttributeSet attributes = TemplateConfigurationBuilder.getAttributes((ConfigurationChildBuilder)clustering);
        attributes.attribute(ClusteringConfiguration.BIAS_ACQUISITION).reset();
        attributes.attribute(ClusteringConfiguration.BIAS_LIFESPAN).reset();
        attributes.attribute(ClusteringConfiguration.INVALIDATION_BATCH_SIZE).reset();
        builder.dataContainer().dataContainer(null);
        builder.expiration().lifespan(-1L).maxIdle(-1L);
        builder.memory().size(-1L).evictionStrategy(EvictionStrategy.MANUAL);
        builder.persistence().clearStores();
    }
}

