/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.server.session.SessionIdGenerator;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleClassTable;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerConfiguration;
import org.wildfly.clustering.web.sso.SSOManagerFactory;
import org.wildfly.clustering.web.undertow.IdentifierFactoryAdapter;

public class SSOManagerBuilder<A, D, S, L>
implements CapabilityServiceBuilder<SSOManager<A, D, S, L, Batch>>,
Service<SSOManager<A, D, S, L, Batch>>,
SSOManagerConfiguration<L, MarshallingContext> {
    private final ServiceName name;
    private final ValueDependency<SSOManagerFactory<A, D, S, Batch>> factory;
    private final ValueDependency<SessionIdGenerator> generator;
    private final LocalContextFactory<L> localContextFactory;
    private volatile SSOManager<A, D, S, L, Batch> manager;
    private volatile MarshallingContext context;

    public SSOManagerBuilder(ServiceName name, ValueDependency<SSOManagerFactory<A, D, S, Batch>> factory, ValueDependency<SessionIdGenerator> generator, LocalContextFactory<L> localContextFactory) {
        this.name = name;
        this.factory = factory;
        this.generator = generator;
        this.localContextFactory = localContextFactory;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public ServiceBuilder<SSOManager<A, D, S, L, Batch>> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)this);
        return new CompositeDependency(new Dependency[]{this.factory, this.generator}).register(builder);
    }

    public void start(StartContext context) throws StartException {
        SSOManagerFactory factory = (SSOManagerFactory)this.factory.getValue();
        Module module = Module.forClass(this.getClass());
        this.context = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)module), null);
        this.manager = factory.createSSOManager((SSOManagerConfiguration)this);
        this.manager.start();
    }

    public void stop(StopContext context) {
        this.manager.stop();
        this.manager = null;
        this.context = null;
    }

    public SSOManager<A, D, S, L, Batch> getValue() {
        return this.manager;
    }

    public IdentifierFactory<String> getIdentifierFactory() {
        return new IdentifierFactoryAdapter((SessionIdGenerator)this.generator.getValue());
    }

    public LocalContextFactory<L> getLocalContextFactory() {
        return this.localContextFactory;
    }

    public MarshalledValueFactory<MarshallingContext> getMarshalledValueFactory() {
        return new SimpleMarshalledValueFactory(this.context);
    }

    public MarshallingContext getMarshallingContext() {
        return this.context;
    }

    static enum MarshallingVersion implements Function<Module, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(Module module) {
                ModuleLoader loader = module.getModuleLoader();
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)loader));
                config.setClassTable((ClassTable)new SimpleClassTable(new Class[]{Serializable.class, Externalizable.class}));
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(Module module) {
                ModuleLoader loader = module.getModuleLoader();
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)loader));
                config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)module.getClassLoader()));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable((ClassLoader)module.getClassLoader()));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

