/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.impl.InMemorySingleSignOnManager;
import io.undertow.security.impl.SingleSignOnManager;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.SimpleCapabilityServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.sso.SSOManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOnManagerBuilder;
import org.wildfly.extension.undertow.security.sso.DistributableHostSingleSignOnManagerBuilderProvider;

public class DistributableSingleSignOnManagerBuilderProvider
implements DistributableHostSingleSignOnManagerBuilderProvider {
    private static final SSOManagerFactoryBuilderProvider<Batch> PROVIDER = DistributableSingleSignOnManagerBuilderProvider.loadProvider();

    private static SSOManagerFactoryBuilderProvider<Batch> loadProvider() {
        Iterator<SSOManagerFactoryBuilderProvider> iterator = ServiceLoader.load(SSOManagerFactoryBuilderProvider.class, SSOManagerFactoryBuilderProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            SSOManagerFactoryBuilderProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    public CapabilityServiceBuilder<SingleSignOnManager> getBuilder(ServiceName name, String serverName, String hostName) {
        return PROVIDER != null ? new DistributableSingleSignOnManagerBuilder(name, serverName, hostName, PROVIDER) : new SimpleCapabilityServiceBuilder(name, (Object)new InMemorySingleSignOnManager());
    }
}

