/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.sql.DataSource;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityBootstrapService;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.spi.ClusteringDefaultRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.messaging.activemq.ActiveMQServerResource;
import org.wildfly.extension.messaging.activemq.ActiveMQServerService;
import org.wildfly.extension.messaging.activemq.AddressSettingAdd;
import org.wildfly.extension.messaging.activemq.BridgeAdd;
import org.wildfly.extension.messaging.activemq.BridgeDefinition;
import org.wildfly.extension.messaging.activemq.BroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.Capabilities;
import org.wildfly.extension.messaging.activemq.ClusterConnectionAdd;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.ConnectorServiceDefinition;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.DivertAdd;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.GroupingHandlerAdd;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.PathDefinition;
import org.wildfly.extension.messaging.activemq.PropertySQLProviderFactory;
import org.wildfly.extension.messaging.activemq.QueueAdd;
import org.wildfly.extension.messaging.activemq.SecurityRoleDefinition;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.ha.HAPolicyConfigurationBuilder;
import org.wildfly.extension.messaging.activemq.jms.JMSService;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.source.CredentialSource;

class ServerAdd
extends AbstractAddStepHandler {
    static final String PATH_BASE = "paths";
    public static final ServerAdd INSTANCE = new ServerAdd();

    private ServerAdd() {
        super(Capabilities.ACTIVEMQ_SERVER_CAPABILITY, ServerDefinition.ATTRIBUTES);
    }

    protected Resource createResource(OperationContext context) {
        ActiveMQServerResource resource = new ActiveMQServerResource();
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
        return resource;
    }

    protected void populateModel(OperationContext context, ModelNode operation, final Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode model = Resource.Tools.readModel((Resource)resource);
                for (String path : PathDefinition.PATHS.keySet()) {
                    if (model.get("path").hasDefined(path)) continue;
                    PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"path", (String)path)});
                    context.createResource(pathAddress);
                }
            }
        }, OperationContext.Stage.MODEL);
        context.addStep((operationContext, model) -> {
            if (ServerDefinition.JOURNAL_DATASOURCE.resolveModelAttribute(context, model).isDefined()) {
                this.checkNoAttributesIsDefined(ServerDefinition.JOURNAL_DATASOURCE.getName(), operationContext.getCurrentAddress(), model, new AttributeDefinition[]{ServerDefinition.JOURNAL_TYPE, ServerDefinition.JOURNAL_BUFFER_TIMEOUT, ServerDefinition.JOURNAL_BUFFER_SIZE, ServerDefinition.JOURNAL_SYNC_TRANSACTIONAL, ServerDefinition.JOURNAL_SYNC_NON_TRANSACTIONAL, ServerDefinition.LOG_JOURNAL_WRITE_RATE, ServerDefinition.JOURNAL_FILE_SIZE, ServerDefinition.JOURNAL_MIN_FILES, ServerDefinition.JOURNAL_POOL_FILES, ServerDefinition.JOURNAL_COMPACT_PERCENTAGE, ServerDefinition.JOURNAL_COMPACT_MIN_FILES, ServerDefinition.JOURNAL_MAX_IO, ServerDefinition.CREATE_BINDINGS_DIR, ServerDefinition.CREATE_JOURNAL_DIR});
            }
        }, OperationContext.Stage.MODEL);
    }

    private void checkNoAttributesIsDefined(String definedAttributeName, PathAddress address, ModelNode model, AttributeDefinition ... attrs) throws OperationFailedException {
        ArrayList<String> definedAttributes = new ArrayList<String>();
        for (AttributeDefinition attr : attrs) {
            if (!model.get(attr.getName()).isDefined()) continue;
            definedAttributes.add(attr.getName());
        }
        if (!definedAttributes.isEmpty()) {
            MessagingLogger.ROOT_LOGGER.invalidConfiguration(address, definedAttributeName, definedAttributes);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, final Resource resource) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName groupBinding;
                String clusterName;
                ServiceName commandDispatcherFactoryServiceName;
                ModelNode channel;
                String key;
                String name;
                ModelNode dataSource;
                ServiceTarget serviceTarget = context.getServiceTarget();
                String serverName = context.getCurrentAddressValue();
                ModelNode model = Resource.Tools.readModel((Resource)resource);
                Configuration configuration = ServerAdd.this.transformConfig(context, serverName, model);
                String bindingsPath = PathDefinition.PATHS.get("bindings-directory").resolveModelAttribute(context, model.get(new String[]{"path", "bindings-directory"})).asString();
                String bindingsRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "bindings-directory"})).asString();
                String journalPath = PathDefinition.PATHS.get("journal-directory").resolveModelAttribute(context, model.get(new String[]{"path", "journal-directory"})).asString();
                String journalRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "journal-directory"})).asString();
                String largeMessagePath = PathDefinition.PATHS.get("large-messages-directory").resolveModelAttribute(context, model.get(new String[]{"path", "large-messages-directory"})).asString();
                String largeMessageRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "large-messages-directory"})).asString();
                String pagingPath = PathDefinition.PATHS.get("paging-directory").resolveModelAttribute(context, model.get(new String[]{"path", "paging-directory"})).asString();
                String pagingRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "paging-directory"})).asString();
                ActiveMQServerService serverService = new ActiveMQServerService(configuration, new ActiveMQServerService.PathConfig(bindingsPath, bindingsRelativeToPath, journalPath, journalRelativeToPath, largeMessagePath, largeMessageRelativeToPath, pagingPath, pagingRelativeToPath));
                ServerAdd.this.processIncomingInterceptors(CommonAttributes.INCOMING_INTERCEPTORS.resolveModelAttribute(context, operation), serverService);
                ServerAdd.this.processOutgoingInterceptors(CommonAttributes.OUTGOING_INTERCEPTORS.resolveModelAttribute(context, operation), serverService);
                ServiceName activeMQServiceName = MessagingServices.getActiveMQServiceName(serverName);
                ServiceBuilder serviceBuilder = serviceTarget.addService(activeMQServiceName, (Service)serverService);
                if (context.hasOptionalCapability("org.wildfly.management.jmx", Capabilities.ACTIVEMQ_SERVER_CAPABILITY.getDynamicName(serverName), null)) {
                    ServiceName jmxCapability = context.getCapabilityServiceName("org.wildfly.management.jmx", MBeanServer.class);
                    serviceBuilder.addDependency(jmxCapability, MBeanServer.class, serverService.getMBeanServer());
                }
                if ((dataSource = ServerDefinition.JOURNAL_DATASOURCE.resolveModelAttribute(context, model)).isDefined()) {
                    ServiceName dataSourceCapability = context.getCapabilityServiceName("org.wildfly.data-source", dataSource.asString(), DataSource.class);
                    serviceBuilder.addDependency(dataSourceCapability, DataSource.class, serverService.getDataSource());
                }
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, serverService.getPathManagerInjector());
                ModelNode elytronSecurityDomain = ServerDefinition.ELYTRON_DOMAIN.resolveModelAttribute(context, model);
                if (elytronSecurityDomain.isDefined()) {
                    ServiceName elytronDomainCapability = context.getCapabilityServiceName("org.wildfly.security.security-domain", elytronSecurityDomain.asString(), SecurityDomain.class);
                    serviceBuilder.addDependency(elytronDomainCapability, SecurityDomain.class, serverService.getElytronDomainInjector());
                } else {
                    String domain = ServerDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, model).asString();
                    serviceBuilder.addDependency(ServiceBuilder.DependencyType.REQUIRED, SecurityDomainService.SERVICE_NAME.append(new String[]{domain}), SecurityDomainContext.class, serverService.getSecurityDomainContextInjector()).addDependency(SecurityBootstrapService.SERVICE_NAME);
                }
                ServerAdd.addBridgeCredentialStoreReference(serverService, configuration, BridgeDefinition.CREDENTIAL_REFERENCE, context, model, serviceBuilder);
                ServerAdd.addClusterCredentialStoreReference(serverService, ServerDefinition.CREDENTIAL_REFERENCE, context, model, serviceBuilder);
                HashSet<String> socketBindings = new HashSet<String>();
                TransportConfigOperationHandlers.processAcceptors(context, configuration, model, socketBindings);
                if (model.hasDefined("http-acceptor")) {
                    for (Property property : model.get("http-acceptor").asPropertyList()) {
                        String httpListener = HTTPAcceptorDefinition.HTTP_LISTENER.resolveModelAttribute(context, property.getValue()).asString();
                        serviceBuilder.addDependency(MessagingServices.HTTP_UPGRADE_REGISTRY.append(new String[]{httpListener}));
                    }
                }
                for (String string : socketBindings) {
                    ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{string});
                    serviceBuilder.addDependency(socketName, SocketBinding.class, serverService.getSocketBindingInjector(string));
                }
                HashSet<String> connectorsSocketBindings = new HashSet<String>();
                TransportConfigOperationHandlers.processConnectors(context, configuration, model, connectorsSocketBindings);
                for (String connectorSocketBinding : connectorsSocketBindings) {
                    boolean outbound = ServerAdd.this.isOutBoundSocketBinding(context, connectorSocketBinding);
                    if (outbound) {
                        ServiceName outboundSocketName = OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{connectorSocketBinding});
                        serviceBuilder.addDependency(outboundSocketName, OutboundSocketBinding.class, serverService.getOutboundSocketBindingInjector(connectorSocketBinding));
                        continue;
                    }
                    ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{connectorSocketBinding});
                    serviceBuilder.addDependency(socketName, SocketBinding.class, serverService.getSocketBindingInjector(connectorSocketBinding));
                }
                BroadcastGroupAdd.addBroadcastGroupConfigs(context, configuration, model);
                List list = configuration.getBroadcastGroupConfigurations();
                Map discoveryGroupConfigurations = configuration.getDiscoveryGroupConfigurations();
                if (list != null) {
                    for (BroadcastGroupConfiguration config : list) {
                        name = config.getName();
                        key = "broadcast" + name;
                        ModelNode broadcastGroupModel = model.get(new String[]{"broadcast-group", name});
                        if (broadcastGroupModel.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName())) {
                            channel = BroadcastGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, broadcastGroupModel);
                            commandDispatcherFactoryServiceName = channel.isDefined() ? ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context, channel.asString()) : ClusteringDefaultRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context);
                            clusterName = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, broadcastGroupModel).asString();
                            serviceBuilder.addDependency(commandDispatcherFactoryServiceName, CommandDispatcherFactory.class, serverService.getCommandDispatcherFactoryInjector(key));
                            serverService.getClusterNames().put(key, clusterName);
                            continue;
                        }
                        groupBinding = GroupBindingService.getBroadcastBaseServiceName(activeMQServiceName).append(new String[]{name});
                        serviceBuilder.addDependency(groupBinding, SocketBinding.class, serverService.getGroupBindingInjector(key));
                    }
                }
                if (discoveryGroupConfigurations != null) {
                    for (BroadcastGroupConfiguration config : discoveryGroupConfigurations.values()) {
                        name = config.getName();
                        key = "discovery" + name;
                        ModelNode discoveryGroupModel = model.get(new String[]{"discovery-group", name});
                        if (discoveryGroupModel.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName())) {
                            channel = DiscoveryGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, discoveryGroupModel);
                            commandDispatcherFactoryServiceName = channel.isDefined() ? ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context, channel.asString()) : ClusteringDefaultRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context);
                            clusterName = CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, discoveryGroupModel).asString();
                            serviceBuilder.addDependency(commandDispatcherFactoryServiceName, CommandDispatcherFactory.class, serverService.getCommandDispatcherFactoryInjector(key));
                            serverService.getClusterNames().put(key, clusterName);
                            continue;
                        }
                        groupBinding = GroupBindingService.getDiscoveryBaseServiceName(activeMQServiceName).append(new String[]{name});
                        serviceBuilder.addDependency(groupBinding, SocketBinding.class, serverService.getGroupBindingInjector(key));
                    }
                }
                ServiceController activeMQServerServiceController = serviceBuilder.install();
                ((ActiveMQServerResource)resource).setActiveMQServerServiceController((ServiceController<ActiveMQServer>)activeMQServerServiceController);
                boolean overrideInVMSecurity = ServerDefinition.OVERRIDE_IN_VM_SECURITY.resolveModelAttribute(context, operation).asBoolean();
                JMSService.addService(serviceTarget, activeMQServiceName, overrideInVMSecurity);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private boolean isOutBoundSocketBinding(OperationContext context, String name) throws OperationFailedException {
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        for (Resource.ResourceEntry resource : root.getChildren("socket-binding-group")) {
            if (resource.getChildrenNames("socket-binding").contains(name)) {
                return false;
            }
            if (!resource.getChildrenNames("local-destination-outbound-socket-binding").contains(name) && !resource.getChildrenNames("remote-destination-outbound-socket-binding").contains(name)) continue;
            return true;
        }
        throw MessagingLogger.ROOT_LOGGER.noSocketBinding(name);
    }

    private Configuration transformConfig(OperationContext context, String serverName, ModelNode model) throws OperationFailedException {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setName(serverName);
        configuration.setEnabledAsyncConnectionExecution(ServerDefinition.ASYNC_CONNECTION_EXECUTION_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setClusterPassword(ServerDefinition.CLUSTER_PASSWORD.resolveModelAttribute(context, model).asString());
        configuration.setClusterUser(ServerDefinition.CLUSTER_USER.resolveModelAttribute(context, model).asString());
        configuration.setConnectionTTLOverride((long)ServerDefinition.CONNECTION_TTL_OVERRIDE.resolveModelAttribute(context, model).asInt());
        configuration.setCreateBindingsDir(ServerDefinition.CREATE_BINDINGS_DIR.resolveModelAttribute(context, model).asBoolean());
        configuration.setCreateJournalDir(ServerDefinition.CREATE_JOURNAL_DIR.resolveModelAttribute(context, model).asBoolean());
        configuration.setIDCacheSize(ServerDefinition.ID_CACHE_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setJMXDomain(ServerDefinition.JMX_DOMAIN.resolveModelAttribute(context, model).asString());
        configuration.setJMXManagementEnabled(ServerDefinition.JMX_MANAGEMENT_ENABLED.resolveModelAttribute(context, model).asBoolean());
        JournalType journalType = JournalType.valueOf((String)ServerDefinition.JOURNAL_TYPE.resolveModelAttribute(context, model).asString());
        configuration.setJournalType(journalType);
        configuration.setJournalBufferSize_AIO(ServerDefinition.JOURNAL_BUFFER_SIZE.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalBufferSizeAio()));
        configuration.setJournalBufferTimeout_AIO(ServerDefinition.JOURNAL_BUFFER_TIMEOUT.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutAio()));
        configuration.setJournalMaxIO_AIO(ServerDefinition.JOURNAL_MAX_IO.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio()));
        configuration.setJournalBufferSize_NIO(ServerDefinition.JOURNAL_BUFFER_SIZE.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalBufferSizeNio()));
        configuration.setJournalBufferTimeout_NIO(ServerDefinition.JOURNAL_BUFFER_TIMEOUT.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutNio()));
        configuration.setJournalMaxIO_NIO(ServerDefinition.JOURNAL_MAX_IO.resolveModelAttribute(context, model).asInt(ActiveMQDefaultConfiguration.getDefaultJournalMaxIoNio()));
        configuration.setJournalCompactMinFiles(ServerDefinition.JOURNAL_COMPACT_MIN_FILES.resolveModelAttribute(context, model).asInt());
        configuration.setJournalCompactPercentage(ServerDefinition.JOURNAL_COMPACT_PERCENTAGE.resolveModelAttribute(context, model).asInt());
        configuration.setJournalFileSize(ServerDefinition.JOURNAL_FILE_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setJournalMinFiles(ServerDefinition.JOURNAL_MIN_FILES.resolveModelAttribute(context, model).asInt());
        configuration.setJournalPoolFiles(ServerDefinition.JOURNAL_POOL_FILES.resolveModelAttribute(context, model).asInt());
        configuration.setJournalSyncNonTransactional(ServerDefinition.JOURNAL_SYNC_NON_TRANSACTIONAL.resolveModelAttribute(context, model).asBoolean());
        configuration.setJournalSyncTransactional(ServerDefinition.JOURNAL_SYNC_TRANSACTIONAL.resolveModelAttribute(context, model).asBoolean());
        configuration.setLogJournalWriteRate(ServerDefinition.LOG_JOURNAL_WRITE_RATE.resolveModelAttribute(context, model).asBoolean());
        configuration.setManagementAddress(SimpleString.toSimpleString((String)ServerDefinition.MANAGEMENT_ADDRESS.resolveModelAttribute(context, model).asString()));
        configuration.setManagementNotificationAddress(SimpleString.toSimpleString((String)ServerDefinition.MANAGEMENT_NOTIFICATION_ADDRESS.resolveModelAttribute(context, model).asString()));
        configuration.setMemoryMeasureInterval(ServerDefinition.MEMORY_MEASURE_INTERVAL.resolveModelAttribute(context, model).asLong());
        configuration.setMemoryWarningThreshold(ServerDefinition.MEMORY_WARNING_THRESHOLD.resolveModelAttribute(context, model).asInt());
        configuration.setMessageCounterEnabled(ServerDefinition.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setMessageCounterSamplePeriod((long)ServerDefinition.MESSAGE_COUNTER_SAMPLE_PERIOD.resolveModelAttribute(context, model).asInt());
        configuration.setMessageCounterMaxDayHistory(ServerDefinition.MESSAGE_COUNTER_MAX_DAY_HISTORY.resolveModelAttribute(context, model).asInt());
        configuration.setMessageExpiryScanPeriod(ServerDefinition.MESSAGE_EXPIRY_SCAN_PERIOD.resolveModelAttribute(context, model).asLong());
        configuration.setMessageExpiryThreadPriority(ServerDefinition.MESSAGE_EXPIRY_THREAD_PRIORITY.resolveModelAttribute(context, model).asInt());
        configuration.setJournalPerfBlastPages(ServerDefinition.PERF_BLAST_PAGES.resolveModelAttribute(context, model).asInt());
        configuration.setPersistDeliveryCountBeforeDelivery(ServerDefinition.PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY.resolveModelAttribute(context, model).asBoolean());
        configuration.setPageMaxConcurrentIO(ServerDefinition.PAGE_MAX_CONCURRENT_IO.resolveModelAttribute(context, model).asInt());
        configuration.setPersistenceEnabled(ServerDefinition.PERSISTENCE_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setPersistIDCache(ServerDefinition.PERSIST_ID_CACHE.resolveModelAttribute(context, model).asBoolean());
        configuration.setRunSyncSpeedTest(ServerDefinition.RUN_SYNC_SPEED_TEST.resolveModelAttribute(context, model).asBoolean());
        configuration.setScheduledThreadPoolMaxSize(ServerDefinition.SCHEDULED_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setSecurityEnabled(ServerDefinition.SECURITY_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setSecurityInvalidationInterval(ServerDefinition.SECURITY_INVALIDATION_INTERVAL.resolveModelAttribute(context, model).asLong());
        configuration.setServerDumpInterval(ServerDefinition.SERVER_DUMP_INTERVAL.resolveModelAttribute(context, model).asLong());
        configuration.setThreadPoolMaxSize(ServerDefinition.THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setTransactionTimeout(ServerDefinition.TRANSACTION_TIMEOUT.resolveModelAttribute(context, model).asLong());
        configuration.setTransactionTimeoutScanPeriod(ServerDefinition.TRANSACTION_TIMEOUT_SCAN_PERIOD.resolveModelAttribute(context, model).asLong());
        configuration.setWildcardRoutingEnabled(ServerDefinition.WILD_CARD_ROUTING_ENABLED.resolveModelAttribute(context, model).asBoolean());
        ServerAdd.processStorageConfiguration(context, model, (Configuration)configuration);
        HAPolicyConfigurationBuilder.addHAPolicyConfiguration(context, (Configuration)configuration, model);
        ServerAdd.processAddressSettings(context, (Configuration)configuration, model);
        ServerAdd.processSecuritySettings(context, (Configuration)configuration, model);
        GroupingHandlerAdd.addGroupingHandlerConfig(context, (Configuration)configuration, model);
        DiscoveryGroupAdd.addDiscoveryGroupConfigs(context, (Configuration)configuration, model);
        DivertAdd.addDivertConfigs(context, (Configuration)configuration, model);
        QueueAdd.addQueueConfigs(context, (Configuration)configuration, model);
        BridgeAdd.addBridgeConfigs(context, (Configuration)configuration, model);
        ClusterConnectionAdd.addClusterConnectionConfigs(context, (Configuration)configuration, model);
        ConnectorServiceDefinition.addConnectorServiceConfigs(context, (Configuration)configuration, model);
        return configuration;
    }

    private static void processStorageConfiguration(OperationContext context, ModelNode model, Configuration configuration) throws OperationFailedException {
        ModelNode journalDataSource = ServerDefinition.JOURNAL_DATASOURCE.resolveModelAttribute(context, model);
        if (!journalDataSource.isDefined()) {
            return;
        }
        DatabaseStorageConfiguration storageConfiguration = new DatabaseStorageConfiguration();
        storageConfiguration.setBindingsTableName(ServerDefinition.JOURNAL_BINDINGS_TABLE.resolveModelAttribute(context, model).asString());
        storageConfiguration.setJMSBindingsTableName(ServerDefinition.JOURNAL_JMS_BINDINGS_TABLE.resolveModelAttribute(context, model).asString());
        storageConfiguration.setMessageTableName(ServerDefinition.JOURNAL_MESSAGES_TABLE.resolveModelAttribute(context, model).asString());
        storageConfiguration.setLargeMessageTableName(ServerDefinition.JOURNAL_LARGE_MESSAGES_TABLE.resolveModelAttribute(context, model).asString());
        storageConfiguration.setPageStoreTableName(ServerDefinition.JOURNAL_PAGE_STORE_TABLE.resolveModelAttribute(context, model).asString());
        storageConfiguration.setJdbcNetworkTimeout(ServerDefinition.JOURNAL_JDBC_NETWORK_TIMEOUT.resolveModelAttribute(context, model).asInt());
        ModelNode databaseNode = ServerDefinition.JOURNAL_DATABASE.resolveModelAttribute(context, model);
        String database = databaseNode.isDefined() ? databaseNode.asString() : null;
        try {
            storageConfiguration.setSqlProvider((SQLProvider.Factory)new PropertySQLProviderFactory(database));
        }
        catch (IOException e) {
            throw new OperationFailedException((Throwable)e);
        }
        configuration.setStoreConfiguration((StoreConfiguration)storageConfiguration);
    }

    static void processAddressSettings(OperationContext context, Configuration configuration, ModelNode params) throws OperationFailedException {
        if (params.hasDefined("address-setting")) {
            for (Property property : params.get("address-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                AddressSettings settings = AddressSettingAdd.createSettings(context, config);
                configuration.getAddressesSettings().put(match, settings);
            }
        }
    }

    private List<Class> unwrapClasses(List<ModelNode> classesModel) throws OperationFailedException {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ModelNode classModel : classesModel) {
            Class clazz = ServerAdd.unwrapClass(classModel);
            classes.add(clazz);
        }
        return classes;
    }

    private static Class unwrapClass(ModelNode classModel) throws OperationFailedException {
        String className = classModel.get("name").asString();
        String moduleName = classModel.get("module").asString();
        try {
            ModuleIdentifier moduleID = ModuleIdentifier.fromString((String)moduleName);
            Module module = Module.getCallerModuleLoader().loadModule(moduleID);
            Class clazz = module.getClassLoader().loadClass(className);
            return clazz;
        }
        catch (Exception e) {
            throw MessagingLogger.ROOT_LOGGER.unableToLoadClassFromModule(className, moduleName);
        }
    }

    private void processIncomingInterceptors(ModelNode model, ActiveMQServerService serverService) throws OperationFailedException {
        if (!model.isDefined()) {
            return;
        }
        List interceptors = model.asList();
        for (Class clazz : this.unwrapClasses(interceptors)) {
            try {
                Interceptor interceptor = (Interceptor)Interceptor.class.cast(clazz.newInstance());
                serverService.getIncomingInterceptors().add(interceptor);
            }
            catch (Exception e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    private void processOutgoingInterceptors(ModelNode model, ActiveMQServerService serverService) throws OperationFailedException {
        if (!model.isDefined()) {
            return;
        }
        List interceptors = model.asList();
        for (Class clazz : this.unwrapClasses(interceptors)) {
            try {
                Interceptor interceptor = (Interceptor)Interceptor.class.cast(clazz.newInstance());
                serverService.getOutgoingInterceptors().add(interceptor);
            }
            catch (Exception e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    static void processSecuritySettings(OperationContext context, Configuration configuration, ModelNode params) throws OperationFailedException {
        if (params.get("security-setting").isDefined()) {
            for (Property property : params.get("security-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                if (!config.hasDefined("role")) continue;
                HashSet<Role> roles = new HashSet<Role>();
                for (Property role : config.get("role").asPropertyList()) {
                    roles.add(SecurityRoleDefinition.transform(context, role.getName(), role.getValue()));
                }
                configuration.getSecurityRoles().put(match, roles);
            }
        }
    }

    private static void addBridgeCredentialStoreReference(ActiveMQServerService amqService, Configuration configuration, ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, OperationContext context, ModelNode model, ServiceBuilder<?> serviceBuilder) throws OperationFailedException {
        for (BridgeConfiguration bridgeConfiguration : configuration.getBridgeConfigurations()) {
            ModelNode value;
            String name = bridgeConfiguration.getName();
            InjectedValue<ExceptionSupplier<CredentialSource, Exception>> injector = amqService.getBridgeCredentialSourceSupplierInjector(name);
            String[] modelFilter = new String[]{"bridge", name};
            ModelNode filteredModelNode = model;
            if (modelFilter != null && modelFilter.length > 0) {
                for (String path : modelFilter) {
                    if (!filteredModelNode.get(path).isDefined()) break;
                    filteredModelNode = filteredModelNode.get(path);
                }
            }
            if (!(value = credentialReferenceAttributeDefinition.resolveModelAttribute(context, filteredModelNode)).isDefined()) continue;
            injector.inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)credentialReferenceAttributeDefinition, (ModelNode)filteredModelNode, serviceBuilder));
        }
    }

    private static void addClusterCredentialStoreReference(ActiveMQServerService amqService, ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, OperationContext context, ModelNode model, ServiceBuilder<?> serviceBuilder) throws OperationFailedException {
        ModelNode value = credentialReferenceAttributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            amqService.getClusterCredentialSourceSupplierInjector().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)credentialReferenceAttributeDefinition, (ModelNode)model, serviceBuilder));
        }
    }
}

