/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.provider.LocalServiceProviderRegistry;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class LocalServiceProviderRegistryBuilder<T>
implements CapabilityServiceBuilder<ServiceProviderRegistry<T>>,
Value<ServiceProviderRegistry<T>> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private volatile ValueDependency<Group> group;

    public LocalServiceProviderRegistryBuilder(ServiceName name, String containerName, String cacheName) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceProviderRegistry<T> getValue() {
        return new LocalServiceProviderRegistry((Group)this.group.getValue());
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<ServiceProviderRegistry<T>> configure(CapabilityServiceSupport support) {
        this.group = new InjectedValueDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.cacheName), Group.class);
        return this;
    }

    public ServiceBuilder<ServiceProviderRegistry<T>> build(ServiceTarget target) {
        return this.group.register(target.addService(this.name, (Service)new ValueService((Value)this)).setInitialMode(ServiceController.Mode.ON_DEMAND));
    }
}

