/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.clustering.function.Functions;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Address;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.server.group.CacheGroup;
import org.wildfly.clustering.server.group.CacheGroupConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.SuppliedValueService;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.NodeFactory;

public class CacheGroupBuilder
implements CapabilityServiceBuilder<Group>,
CacheGroupConfiguration,
Supplier<CacheGroup> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private volatile ValueDependency<Cache<?, ?>> cache;
    private volatile ValueDependency<NodeFactory<Address>> factory;

    public CacheGroupBuilder(ServiceName name, String containerName, String cacheName) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public CacheGroup get() {
        return new CacheGroup(this);
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<Group> configure(CapabilityServiceSupport support) {
        this.cache = new InjectedValueDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.containerName, this.cacheName), Cache.class);
        this.factory = new InjectedValueDependency(ClusteringRequirement.GROUP.getServiceName(support, this.containerName), NodeFactory.class);
        return this;
    }

    public ServiceBuilder<Group> build(ServiceTarget target) {
        SuppliedValueService service = new SuppliedValueService(Functions.identity(), (Supplier)this, Consumers.close());
        ServiceBuilder builder = target.addService(this.name, (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
        return new CompositeDependency(new Dependency[]{this.cache, this.factory}).register(builder);
    }

    @Override
    public Cache<?, ?> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public NodeFactory<Address> getMemberFactory() {
        return (NodeFactory)this.factory.getValue();
    }
}

