/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Buffer;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.dispatcher.CommandMarshaller;
import org.wildfly.clustering.server.dispatcher.NoSuchService;
import org.wildfly.clustering.server.dispatcher.SimpleCommandResponse;
import org.wildfly.clustering.server.group.Group;

public class ChannelCommandDispatcher<C>
implements CommandDispatcher<C> {
    private static final RspFilter FILTER = new RspFilter(){

        public boolean isAcceptable(Object response, Address sender) {
            return !(response instanceof NoSuchService);
        }

        public boolean needMoreResponses() {
            return true;
        }
    };
    private final MessageDispatcher dispatcher;
    private final CommandMarshaller<C> marshaller;
    private final Group<Address> group;
    private final long timeout;
    private final CommandDispatcher<C> localDispatcher;
    private final Runnable closeTask;

    public ChannelCommandDispatcher(MessageDispatcher dispatcher, CommandMarshaller<C> marshaller, Group<Address> group, long timeout, CommandDispatcher<C> localDispatcher, Runnable closeTask) {
        this.dispatcher = dispatcher;
        this.marshaller = marshaller;
        this.group = group;
        this.timeout = timeout;
        this.localDispatcher = localDispatcher;
        this.closeTask = closeTask;
    }

    public C getContext() {
        return (C)this.localDispatcher.getContext();
    }

    public void close() {
        this.closeTask.run();
    }

    public <R> Map<Node, CommandResponse<R>> executeOnCluster(Command<R, ? super C> command, Node ... excludedNodes) throws CommandDispatcherException {
        Buffer buffer = this.createBuffer(command);
        RequestOptions options = this.createRequestOptions(excludedNodes);
        try {
            RspList responses = this.dispatcher.castMessage(null, buffer, options);
            HashMap<Node, CommandResponse<R>> results = new HashMap<Node, CommandResponse<R>>();
            for (Map.Entry entry : responses.entrySet()) {
                Address address = (Address)entry.getKey();
                Rsp response = (Rsp)entry.getValue();
                if (!response.wasReceived() || response.wasSuspected()) continue;
                results.put(this.group.createNode(address), ChannelCommandDispatcher.createCommandResponse(response));
            }
            return results;
        }
        catch (Exception e) {
            throw new CommandDispatcherException((Throwable)e);
        }
    }

    public <R> Map<Node, Future<R>> submitOnCluster(Command<R, ? super C> command, Node ... excludedNodes) throws CommandDispatcherException {
        Set excluded = Stream.of(excludedNodes).collect(Collectors.toSet());
        HashMap<Node, Future<R>> results = new HashMap<Node, Future<R>>();
        Buffer buffer = this.createBuffer(command);
        RequestOptions options = this.createRequestOptions();
        for (Node node : this.group.getMembership().getMembers()) {
            if (excluded.contains(node)) continue;
            try {
                results.put(node, this.dispatcher.sendMessageWithFuture((Address)this.group.getAddress(node), buffer, options));
            }
            catch (Exception e) {
                throw new CommandDispatcherException((Throwable)e);
            }
        }
        return results;
    }

    public <R> CommandResponse<R> executeOnNode(Command<R, ? super C> command, Node node) throws CommandDispatcherException {
        if (this.isLocal(node)) {
            return this.localDispatcher.executeOnNode(command, node);
        }
        Buffer buffer = this.createBuffer(command);
        RequestOptions options = this.createRequestOptions();
        try {
            CompletableFuture future = this.dispatcher.sendMessageWithFuture((Address)this.group.getAddress(node), buffer, options);
            return new SimpleCommandResponse(future.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new SimpleCommandResponse(e);
        }
        catch (ExecutionException e) {
            return new SimpleCommandResponse(e);
        }
        catch (Exception e) {
            throw new CommandDispatcherException((Throwable)e);
        }
    }

    public <R> Future<R> submitOnNode(Command<R, ? super C> command, Node node) throws CommandDispatcherException {
        if (this.isLocal(node)) {
            return this.localDispatcher.submitOnNode(command, node);
        }
        Buffer buffer = this.createBuffer(command);
        RequestOptions options = this.createRequestOptions();
        try {
            return this.dispatcher.sendMessageWithFuture((Address)this.group.getAddress(node), buffer, options);
        }
        catch (Exception e) {
            throw new CommandDispatcherException((Throwable)e);
        }
    }

    public <R> Future<R> submit(Node node, Buffer buffer, RequestOptions options) throws CommandDispatcherException {
        try {
            return this.dispatcher.sendMessageWithFuture((Address)this.group.getAddress(node), buffer, options);
        }
        catch (Exception e) {
            throw new CommandDispatcherException((Throwable)e);
        }
    }

    private <R> Buffer createBuffer(Command<R, ? super C> command) {
        try {
            return new Buffer(this.marshaller.marshal(command));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean isLocal(Node node) {
        return this.getLocalAddress().equals(this.group.getAddress(node));
    }

    private RequestOptions createRequestOptions(Node ... excludedNodes) {
        Address[] excludedAddresses = new Address[excludedNodes.length];
        for (int i = 0; i < excludedNodes.length; ++i) {
            excludedAddresses[i] = (Address)this.group.getAddress(excludedNodes[i]);
        }
        return this.createRequestOptions().exclusionList(excludedAddresses);
    }

    private RequestOptions createRequestOptions() {
        return new RequestOptions(ResponseMode.GET_ALL, this.timeout, false, FILTER, new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    }

    static <R> CommandResponse<R> createCommandResponse(Rsp<R> response) {
        Throwable exception = response.getException();
        return exception != null ? new SimpleCommandResponse(exception) : new SimpleCommandResponse<Object>(response.getValue());
    }

    private Address getLocalAddress() {
        return this.dispatcher.getChannel().getAddress();
    }
}

