/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.io;

import com.sun.corba.se.impl.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.corba.Bridge;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ObjectStreamField
implements Comparable {
    private static final Bridge bridge = (Bridge)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Bridge.get();
        }
    });
    private String name;
    private char type;
    private Field field;
    private String typeString;
    private Class clazz;
    private String signature;
    private long fieldID = -1L;

    ObjectStreamField(String n, Class clazz) {
        this.name = n;
        this.clazz = clazz;
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                this.type = (char)73;
            } else if (clazz == Byte.TYPE) {
                this.type = (char)66;
            } else if (clazz == Long.TYPE) {
                this.type = (char)74;
            } else if (clazz == Float.TYPE) {
                this.type = (char)70;
            } else if (clazz == Double.TYPE) {
                this.type = (char)68;
            } else if (clazz == Short.TYPE) {
                this.type = (char)83;
            } else if (clazz == Character.TYPE) {
                this.type = (char)67;
            } else if (clazz == Boolean.TYPE) {
                this.type = (char)90;
            }
        } else if (clazz.isArray()) {
            this.type = (char)91;
            this.typeString = ObjectStreamClass.getSignature(clazz);
        } else {
            this.type = (char)76;
            this.typeString = ObjectStreamClass.getSignature(clazz);
        }
        this.signature = this.typeString != null ? this.typeString : String.valueOf(this.type);
    }

    ObjectStreamField(Field field) {
        this(field.getName(), field.getType());
        this.setField(field);
    }

    ObjectStreamField(String n, char t, Field f, String ts) {
        this.name = n;
        this.type = t;
        this.setField(f);
        this.typeString = ts;
        this.signature = this.typeString != null ? this.typeString : String.valueOf(this.type);
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        if (this.clazz != null) {
            return this.clazz;
        }
        switch (this.type) {
            case 'B': {
                this.clazz = Byte.TYPE;
                break;
            }
            case 'C': {
                this.clazz = Character.TYPE;
                break;
            }
            case 'S': {
                this.clazz = Short.TYPE;
                break;
            }
            case 'I': {
                this.clazz = Integer.TYPE;
                break;
            }
            case 'J': {
                this.clazz = Long.TYPE;
                break;
            }
            case 'F': {
                this.clazz = Float.TYPE;
                break;
            }
            case 'D': {
                this.clazz = Double.TYPE;
                break;
            }
            case 'Z': {
                this.clazz = Boolean.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.clazz = Object.class;
            }
        }
        return this.clazz;
    }

    public char getTypeCode() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    Field getField() {
        return this.field;
    }

    void setField(Field field) {
        this.field = field;
        this.fieldID = bridge.objectFieldOffset(field);
    }

    ObjectStreamField() {
    }

    public boolean isPrimitive() {
        return this.type != '[' && this.type != 'L';
    }

    public int compareTo(Object o) {
        boolean otherprim;
        ObjectStreamField f2 = (ObjectStreamField)o;
        boolean thisprim = this.typeString == null;
        boolean bl = otherprim = f2.typeString == null;
        if (thisprim != otherprim) {
            return thisprim ? -1 : 1;
        }
        return this.name.compareTo(f2.name);
    }

    public boolean typeEquals(ObjectStreamField other) {
        if (other == null || this.type != other.type) {
            return false;
        }
        if (this.typeString == null && other.typeString == null) {
            return true;
        }
        return ObjectStreamClass.compareClassNames(this.typeString, other.typeString, '/');
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        if (this.typeString != null) {
            return this.typeString + " " + this.name;
        }
        return this.type + " " + this.name;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public long getFieldID() {
        return this.fieldID;
    }
}

