/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.subsystem.DefaultDistinctNameService;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

class EJBDefaultDistinctNameWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final EJBDefaultDistinctNameWriteHandler INSTANCE = new EJBDefaultDistinctNameWriteHandler((AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_DISTINCT_NAME);
    private final AttributeDefinition attributeDefinition;

    private EJBDefaultDistinctNameWriteHandler(AttributeDefinition attributeDefinition) {
        super(new AttributeDefinition[]{attributeDefinition});
        this.attributeDefinition = attributeDefinition;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateDefaultDistinctName(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateDefaultDistinctName(context, restored);
    }

    void updateDefaultDistinctName(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode defaultDistinctName = this.attributeDefinition.resolveModelAttribute(context, model);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController existingDefaultLocalEJBReceiverServiceController = registry.getService(DefaultDistinctNameService.SERVICE_NAME);
        DefaultDistinctNameService service = (DefaultDistinctNameService)existingDefaultLocalEJBReceiverServiceController.getValue();
        if (!defaultDistinctName.isDefined()) {
            service.setDefaultDistinctName(null);
        } else {
            service.setDefaultDistinctName(defaultDistinctName.asString());
        }
    }
}

