/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commons.marshall.AdvancedExternalizer;

public class Externalizers {
    public static final int UUID = 1200;
    public static final int TOMBSTONE = 1201;
    public static final int EXCLUDE_TOMBSTONES_FILTER = 1202;
    public static final int TOMBSTONE_UPDATE = 1203;
    public static final int FUTURE_UPDATE = 1204;
    public static final int VALUE_EXTRACTOR = 1205;
    public static final int VERSIONED_ENTRY = 1206;
    public static final int EXCLUDE_EMPTY_EXTRACT_VALUE = 1207;
    public static final int FILTER_NULL_VALUE_CONVERTER = 1208;
    public static final int NULL_VALUE = 1209;

    public static class UUIDExternalizer
    implements AdvancedExternalizer<UUID> {
        public Set<Class<? extends UUID>> getTypeClasses() {
            return Collections.singleton(UUID.class);
        }

        public Integer getId() {
            return 1200;
        }

        public void writeObject(ObjectOutput output, UUID uuid) throws IOException {
            output.writeLong(uuid.getMostSignificantBits());
            output.writeLong(uuid.getLeastSignificantBits());
        }

        public UUID readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new UUID(input.readLong(), input.readLong());
        }
    }
}

