/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import java.util.Optional;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorConfiguration;
import org.wildfly.clustering.web.session.RouteLocator;

public class InfinispanRouteLocator
implements RouteLocator {
    private final NodeFactory<Address> factory;
    private final Registry<String, Void> registry;
    private final Cache<String, ?> cache;

    public InfinispanRouteLocator(InfinispanRouteLocatorConfiguration config) {
        this.cache = config.getCache();
        this.registry = config.getRegistry();
        this.factory = config.getNodeFactory();
    }

    public String locate(String sessionId) {
        Node node = Optional.ofNullable(this.locatePrimaryOwner(sessionId)).map(address -> this.factory.createNode(address)).orElse(this.registry.getGroup().getLocalNode());
        Map.Entry entry = this.registry.getEntry(node);
        return entry != null ? (String)entry.getKey() : null;
    }

    private Address locatePrimaryOwner(String sessionId) {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? dist.getPrimaryLocation((Object)new Key((Object)sessionId)) : this.cache.getCacheManager().getAddress();
    }
}

