/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.net.UnknownHostException;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class RemoteStoreBuilder
extends StoreBuilder<RemoteStoreConfiguration, RemoteStoreConfigurationBuilder> {
    private volatile List<ValueDependency<OutboundSocketBinding>> bindings;
    private volatile String remoteCacheName;
    private volatile long socketTimeout;
    private volatile boolean tcpNoDelay;

    public RemoteStoreBuilder(PathAddress cacheAddress) {
        super(cacheAddress, RemoteStoreConfigurationBuilder.class);
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        ServiceBuilder<PersistenceConfiguration> builder = super.build(target);
        for (Dependency dependency : this.bindings) {
            dependency.register(builder);
        }
        return builder;
    }

    @Override
    public Builder<PersistenceConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.remoteCacheName = RemoteStoreResourceDefinition.Attribute.CACHE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.socketTimeout = RemoteStoreResourceDefinition.Attribute.SOCKET_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.tcpNoDelay = RemoteStoreResourceDefinition.Attribute.TCP_NO_DELAY.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.bindings = StringListAttributeDefinition.unwrapValue((ExpressionResolver)context, (ModelNode)RemoteStoreResourceDefinition.Attribute.SOCKET_BINDINGS.resolveModelAttribute((ExpressionResolver)context, model)).stream().map(binding -> new InjectedValueDependency(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getServiceName(context, binding), OutboundSocketBinding.class)).collect(Collectors.toList());
        return super.configure(context, model);
    }

    @Override
    public void accept(RemoteStoreConfigurationBuilder builder) {
        builder.remoteCacheName(this.remoteCacheName).socketTimeout(this.socketTimeout).tcpNoDelay(this.tcpNoDelay);
        this.bindings.stream().map(Value::getValue).forEach(binding -> {
            try {
                builder.addServer().host(binding.getResolvedDestinationAddress().getHostAddress()).port(binding.getDestinationPort());
            }
            catch (UnknownHostException e) {
                throw InfinispanLogger.ROOT_LOGGER.failedToInjectSocketBinding(e, (OutboundSocketBinding)binding);
            }
        });
    }
}

