/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.ReflectionUtil;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.CalendarBridge;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.DynamicBoost;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Latitude;
import org.hibernate.search.annotations.Longitude;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.NumericFields;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.SortableFields;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.Spatials;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.impl.AnnotationFactory;
import org.hibernate.search.exception.SearchException;

public class MappingModelMetadataProvider
implements MetadataProvider {
    private static final Filter FILTER = new Filter(){

        public boolean returnStatic() {
            return false;
        }

        public boolean returnTransient() {
            return true;
        }
    };
    private final MetadataProvider delegate;
    private final SearchMapping mapping;
    private final Map<AnnotatedElement, AnnotationReader> cache = new HashMap<AnnotatedElement, AnnotationReader>(100);
    private Map<Object, Object> defaults;

    public MappingModelMetadataProvider(MetadataProvider delegate, SearchMapping mapping) {
        this.delegate = delegate;
        this.mapping = mapping;
    }

    public Map<Object, Object> getDefaults() {
        if (this.defaults == null) {
            Map delegateDefaults = this.delegate.getDefaults();
            this.defaults = delegateDefaults == null ? new HashMap<Object, Object>() : new HashMap(delegateDefaults);
            this.defaults.put(AnalyzerDefs.class, this.createAnalyzerDefArray());
            if (!this.mapping.getFullTextFilterDefs().isEmpty()) {
                this.defaults.put(FullTextFilterDefs.class, this.createFullTextFilterDefsForMapping());
            }
        }
        return this.defaults;
    }

    public AnnotationReader getAnnotationReader(AnnotatedElement annotatedElement) {
        AnnotationReader reader = this.cache.get(annotatedElement);
        if (reader == null) {
            reader = new MappingModelAnnotationReader(this.mapping, this.delegate, annotatedElement);
            this.cache.put(annotatedElement, reader);
        }
        return reader;
    }

    private AnalyzerDef[] createAnalyzerDefArray() {
        ArrayList<String> globalAnalyzerDefNames = new ArrayList<String>();
        AnalyzerDef[] defs = new AnalyzerDef[this.mapping.getAnalyzerDefs().size()];
        int index = 0;
        for (Map<String, Object> analyzerDef : this.mapping.getAnalyzerDefs()) {
            AnalyzerDef def = this.createAnalyzerDef(analyzerDef);
            if (globalAnalyzerDefNames.contains(def.name())) {
                throw new SearchException("Multiple analyzer definitions with the same name: " + def.name());
            }
            globalAnalyzerDefNames.add(def.name());
            defs[index] = def;
            ++index;
        }
        return defs;
    }

    private FullTextFilterDef[] createFullTextFilterDefsForMapping() {
        Set<Map<String, Object>> fullTextFilterDefs = this.mapping.getFullTextFilterDefs();
        FullTextFilterDef[] filters = new FullTextFilterDef[fullTextFilterDefs.size()];
        int index = 0;
        for (Map<String, Object> filterDef : fullTextFilterDefs) {
            filters[index] = MappingModelMetadataProvider.createFullTextFilterDef(filterDef);
            ++index;
        }
        return filters;
    }

    private static FullTextFilterDef createFullTextFilterDef(Map<String, Object> filterDef) {
        AnnotationDescriptor fullTextFilterDefAnnotation = new AnnotationDescriptor(FullTextFilterDef.class);
        for (Map.Entry<String, Object> entry : filterDef.entrySet()) {
            fullTextFilterDefAnnotation.setValue(entry.getKey(), entry.getValue());
        }
        return (FullTextFilterDef)MappingModelMetadataProvider.createAnnotation(fullTextFilterDefAnnotation);
    }

    private static FullTextFilterDef[] createFullTextFilterDefArray(Set<Map<String, Object>> fullTextFilterDefs) {
        FullTextFilterDef[] filters = new FullTextFilterDef[fullTextFilterDefs.size()];
        int index = 0;
        for (Map<String, Object> filterDef : fullTextFilterDefs) {
            filters[index] = MappingModelMetadataProvider.createFullTextFilterDef(filterDef);
            ++index;
        }
        return filters;
    }

    private AnalyzerDef createAnalyzerDef(Map<String, Object> analyzerDef) {
        AnnotationDescriptor analyzerDefAnnotation = new AnnotationDescriptor(AnalyzerDef.class);
        for (Map.Entry<String, Object> entry : analyzerDef.entrySet()) {
            if ("tokenizer".equals(entry.getKey())) {
                AnnotationDescriptor tokenizerAnnotation = new AnnotationDescriptor(TokenizerDef.class);
                Map tokenizer = (Map)entry.getValue();
                for (Map.Entry<String, Object> entry2 : tokenizer.entrySet()) {
                    if ("params".equals(entry2.getKey())) {
                        MappingModelMetadataProvider.addParamsToAnnotation(tokenizerAnnotation, entry2);
                        continue;
                    }
                    tokenizerAnnotation.setValue(entry2.getKey(), entry2.getValue());
                }
                analyzerDefAnnotation.setValue("tokenizer", (Object)MappingModelMetadataProvider.createAnnotation(tokenizerAnnotation));
                continue;
            }
            if ("filters".equals(entry.getKey())) {
                TokenFilterDef[] filtersArray = this.createFilters((List)entry.getValue());
                analyzerDefAnnotation.setValue("filters", (Object)filtersArray);
                continue;
            }
            if ("charFilters".equals(entry.getKey())) {
                CharFilterDef[] charFiltersArray = this.createCharFilters((List)entry.getValue());
                analyzerDefAnnotation.setValue("charFilters", (Object)charFiltersArray);
                continue;
            }
            analyzerDefAnnotation.setValue(entry.getKey(), entry.getValue());
        }
        return (AnalyzerDef)MappingModelMetadataProvider.createAnnotation(analyzerDefAnnotation);
    }

    private static void addParamsToAnnotation(AnnotationDescriptor annotationDescriptor, Map.Entry<String, Object> entry) {
        Parameter[] paramsArray = MappingModelMetadataProvider.createParams((List)entry.getValue());
        annotationDescriptor.setValue("params", (Object)paramsArray);
    }

    private TokenFilterDef[] createFilters(List<Map<String, Object>> filters) {
        TokenFilterDef[] filtersArray = new TokenFilterDef[filters.size()];
        int index = 0;
        for (Map<String, Object> filter : filters) {
            AnnotationDescriptor filterAnn = new AnnotationDescriptor(TokenFilterDef.class);
            for (Map.Entry<String, Object> filterEntry : filter.entrySet()) {
                if ("params".equals(filterEntry.getKey())) {
                    MappingModelMetadataProvider.addParamsToAnnotation(filterAnn, filterEntry);
                    continue;
                }
                filterAnn.setValue(filterEntry.getKey(), filterEntry.getValue());
            }
            filtersArray[index] = (TokenFilterDef)MappingModelMetadataProvider.createAnnotation(filterAnn);
            ++index;
        }
        return filtersArray;
    }

    private CharFilterDef[] createCharFilters(List<Map<String, Object>> charFilters) {
        CharFilterDef[] charFiltersArray = new CharFilterDef[charFilters.size()];
        int index = 0;
        for (Map<String, Object> charFilter : charFilters) {
            AnnotationDescriptor charFilterAnn = new AnnotationDescriptor(CharFilterDef.class);
            for (Map.Entry<String, Object> charFilterEntry : charFilter.entrySet()) {
                if ("params".equals(charFilterEntry.getKey())) {
                    MappingModelMetadataProvider.addParamsToAnnotation(charFilterAnn, charFilterEntry);
                    continue;
                }
                charFilterAnn.setValue(charFilterEntry.getKey(), charFilterEntry.getValue());
            }
            charFiltersArray[index] = (CharFilterDef)MappingModelMetadataProvider.createAnnotation(charFilterAnn);
            ++index;
        }
        return charFiltersArray;
    }

    private static Parameter[] createParams(List<Map<String, Object>> params) {
        Parameter[] paramArray = new Parameter[params.size()];
        int index = 0;
        for (Map<String, Object> entry : params) {
            AnnotationDescriptor paramAnnotation = new AnnotationDescriptor(Parameter.class);
            paramAnnotation.setValue("name", entry.get("name"));
            paramAnnotation.setValue("value", entry.get("value"));
            paramArray[index] = (Parameter)MappingModelMetadataProvider.createAnnotation(paramAnnotation);
            ++index;
        }
        return paramArray;
    }

    private static Annotation createAnnotation(AnnotationDescriptor annotation) {
        try {
            return AnnotationFactory.create(annotation, annotation.type().getClassLoader());
        }
        catch (Exception exception) {
            return org.hibernate.annotations.common.annotationfactory.AnnotationFactory.create((AnnotationDescriptor)annotation);
        }
    }

    private static class MappingModelAnnotationReader
    implements AnnotationReader {
        private final AnnotationReader delegate;
        private final SearchMapping mapping;
        private transient Annotation[] annotationsArray;
        private transient Map<Class<? extends Annotation>, Annotation> annotations;
        private Class<?> entityType;
        private ElementType elementType;
        private String propertyName;

        public MappingModelAnnotationReader(SearchMapping mapping, MetadataProvider delegate, AnnotatedElement el) {
            this.delegate = delegate.getAnnotationReader(el);
            this.mapping = mapping;
            if (el instanceof Class) {
                this.entityType = (Class)el;
            } else if (el instanceof Field) {
                Field field = (Field)el;
                this.entityType = field.getDeclaringClass();
                this.propertyName = field.getName();
                this.elementType = ElementType.FIELD;
            } else if (el instanceof Method) {
                Method method = (Method)el;
                this.entityType = method.getDeclaringClass();
                this.propertyName = method.getName();
                if (ReflectionUtil.isProperty((Method)method, null, (Filter)FILTER)) {
                    if (this.propertyName.startsWith("get")) {
                        this.propertyName = Introspector.decapitalize(this.propertyName.substring("get".length()));
                    } else if (this.propertyName.startsWith("is")) {
                        this.propertyName = Introspector.decapitalize(this.propertyName.substring("is".length()));
                    } else {
                        throw new RuntimeException("Method " + this.propertyName + " is not a property getter");
                    }
                    this.elementType = ElementType.METHOD;
                } else {
                    this.entityType = null;
                    this.propertyName = null;
                }
            } else {
                this.entityType = null;
                this.propertyName = null;
            }
        }

        private void initAnnotations() {
            if (this.annotationsArray == null) {
                this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
                this.delegatesAnnotationReading();
                if (this.entityType != null) {
                    EntityDescriptor entity = this.mapping.getEntityDescriptor(this.entityType);
                    if (entity != null) {
                        if (this.propertyName == null) {
                            this.createIndexed(entity);
                        } else {
                            PropertyDescriptor property = entity.getPropertyDescriptor(this.propertyName, this.elementType);
                            if (property != null) {
                                this.createDocumentId(property);
                                this.createAnalyzerDiscriminator(property);
                                this.createFields(property);
                                this.createIndexEmbedded(property);
                                this.createContainedIn(property);
                            }
                        }
                    }
                } else {
                    this.delegatesAnnotationReading();
                }
                this.populateAnnotationArray();
            }
        }

        private void createDateBridge(PropertyDescriptor property) {
            Map<String, Object> map = property.getDateBridge();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                AnnotationDescriptor dateBridgeAnnotation = new AnnotationDescriptor(DateBridge.class);
                dateBridgeAnnotation.setValue(entry.getKey(), entry.getValue());
                this.annotations.put(DateBridge.class, MappingModelMetadataProvider.createAnnotation(dateBridgeAnnotation));
            }
        }

        private void createCalendarBridge(PropertyDescriptor property) {
            Map<String, Object> map = property.getCalendarBridge();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                AnnotationDescriptor calendarBrigeAnnotation = new AnnotationDescriptor(CalendarBridge.class);
                calendarBrigeAnnotation.setValue(entry.getKey(), entry.getValue());
                this.annotations.put(CalendarBridge.class, MappingModelMetadataProvider.createAnnotation(calendarBrigeAnnotation));
            }
        }

        private void createDocumentId(PropertyDescriptor property) {
            Map<String, Object> documentId = property.getDocumentId();
            if (documentId != null) {
                AnnotationDescriptor documentIdAnnotation = new AnnotationDescriptor(DocumentId.class);
                for (Map.Entry<String, Object> entry : documentId.entrySet()) {
                    documentIdAnnotation.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(DocumentId.class, MappingModelMetadataProvider.createAnnotation(documentIdAnnotation));
            }
        }

        private void createAnalyzerDiscriminator(PropertyDescriptor property) {
            Map<String, Object> analyzerDiscriminator = property.getAnalyzerDiscriminator();
            if (analyzerDiscriminator != null) {
                AnnotationDescriptor analyzerDiscriminatorAnn = new AnnotationDescriptor(AnalyzerDiscriminator.class);
                for (Map.Entry<String, Object> entry : analyzerDiscriminator.entrySet()) {
                    analyzerDiscriminatorAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(AnalyzerDiscriminator.class, MappingModelMetadataProvider.createAnnotation(analyzerDiscriminatorAnn));
            }
        }

        private void createFields(PropertyDescriptor property) {
            Collection<Map<String, Object>> fields = property.getFields();
            Map<String, Object> spatial = property.getSpatial();
            Map<String, Object> latitude = property.getLatitude();
            Map<String, Object> longitude = property.getLongitude();
            Collection<Map<String, Object>> numericFields = property.getNumericFields();
            Collection<Map<String, Object>> sortableFields = property.getSortableFields();
            ArrayList<org.hibernate.search.annotations.Field> fieldAnnotations = new ArrayList<org.hibernate.search.annotations.Field>(fields.size());
            ArrayList<NumericField> numericFieldAnnotations = new ArrayList<NumericField>(numericFields.size());
            for (Map<String, Object> map : numericFields) {
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(NumericField.class);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    annotationDescriptor.setValue(entry.getKey(), entry.getValue());
                }
                numericFieldAnnotations.add((NumericField)MappingModelMetadataProvider.createAnnotation(annotationDescriptor));
            }
            ArrayList<SortableField> sortableFieldAnnotations = new ArrayList<SortableField>(sortableFields.size());
            for (Map<String, Object> map : sortableFields) {
                AnnotationDescriptor sortableFieldAnnotation = new AnnotationDescriptor(SortableField.class);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    sortableFieldAnnotation.setValue(entry.getKey(), entry.getValue());
                }
                sortableFieldAnnotations.add((SortableField)MappingModelMetadataProvider.createAnnotation(sortableFieldAnnotation));
            }
            for (Map<String, Object> map : fields) {
                AnnotationDescriptor fieldAnnotation = new AnnotationDescriptor(org.hibernate.search.annotations.Field.class);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    if ("analyzer".equals(entry.getKey())) {
                        this.addAnalyzerAnnotationTo(fieldAnnotation, entry);
                        continue;
                    }
                    if ("boost".equals(entry.getKey())) {
                        AnnotationDescriptor boostAnnotation = new AnnotationDescriptor(Boost.class);
                        Map map2 = (Map)entry.getValue();
                        for (Map.Entry boostEntry : map2.entrySet()) {
                            boostAnnotation.setValue((String)boostEntry.getKey(), boostEntry.getValue());
                        }
                        fieldAnnotation.setValue("boost", (Object)MappingModelMetadataProvider.createAnnotation(boostAnnotation));
                        continue;
                    }
                    if ("bridge".equals(entry.getKey())) {
                        AnnotationDescriptor bridgeAnnotation = new AnnotationDescriptor(FieldBridge.class);
                        Map map3 = (Map)entry.getValue();
                        for (Map.Entry bridgeEntry : map3.entrySet()) {
                            if ("params".equals(bridgeEntry.getKey())) {
                                MappingModelMetadataProvider.addParamsToAnnotation(bridgeAnnotation, bridgeEntry);
                                continue;
                            }
                            bridgeAnnotation.setValue((String)bridgeEntry.getKey(), bridgeEntry.getValue());
                        }
                        fieldAnnotation.setValue("bridge", (Object)MappingModelMetadataProvider.createAnnotation(bridgeAnnotation));
                        continue;
                    }
                    fieldAnnotation.setValue(entry.getKey(), entry.getValue());
                }
                fieldAnnotations.add((org.hibernate.search.annotations.Field)MappingModelMetadataProvider.createAnnotation(fieldAnnotation));
            }
            if (spatial != null && spatial.size() > 0) {
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Spatial.class);
                for (Map.Entry<String, Object> entry : spatial.entrySet()) {
                    if ("boost".equals(entry.getKey())) {
                        AnnotationDescriptor annotationDescriptor2 = new AnnotationDescriptor(Boost.class);
                        Map map = (Map)entry.getValue();
                        for (Map.Entry entry2 : map.entrySet()) {
                            annotationDescriptor2.setValue((String)entry2.getKey(), entry2.getValue());
                        }
                        annotationDescriptor.setValue("boost", (Object)MappingModelMetadataProvider.createAnnotation(annotationDescriptor2));
                        continue;
                    }
                    annotationDescriptor.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(Spatial.class, MappingModelMetadataProvider.createAnnotation(annotationDescriptor));
            }
            if (latitude != null && latitude.size() > 0) {
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Latitude.class);
                for (Map.Entry<String, Object> entry : latitude.entrySet()) {
                    annotationDescriptor.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(Latitude.class, MappingModelMetadataProvider.createAnnotation(annotationDescriptor));
            }
            if (longitude != null && longitude.size() > 0) {
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Longitude.class);
                for (Map.Entry<String, Object> entry : longitude.entrySet()) {
                    annotationDescriptor.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(Longitude.class, MappingModelMetadataProvider.createAnnotation(annotationDescriptor));
            }
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Fields.class);
            AnnotationDescriptor annotationDescriptor3 = new AnnotationDescriptor(NumericFields.class);
            AnnotationDescriptor sortableFieldsAnnotation = new AnnotationDescriptor(SortableFields.class);
            org.hibernate.search.annotations.Field[] fieldArray = new org.hibernate.search.annotations.Field[fieldAnnotations.size()];
            org.hibernate.search.annotations.Field[] fieldArray2 = fieldAnnotations.toArray(fieldArray);
            NumericField[] numericFieldArray = new NumericField[numericFieldAnnotations.size()];
            NumericField[] numericFieldArray2 = numericFieldAnnotations.toArray(numericFieldArray);
            annotationDescriptor3.setValue("value", (Object)numericFieldArray2);
            this.annotations.put(NumericFields.class, MappingModelMetadataProvider.createAnnotation(annotationDescriptor3));
            SortableField[] sortableFieldArray = new SortableField[sortableFieldAnnotations.size()];
            SortableField[] sortableFieldAsArray = sortableFieldAnnotations.toArray(sortableFieldArray);
            sortableFieldsAnnotation.setValue("value", (Object)sortableFieldAsArray);
            this.annotations.put(SortableFields.class, MappingModelMetadataProvider.createAnnotation(sortableFieldsAnnotation));
            annotationDescriptor.setValue("value", (Object)fieldArray2);
            this.annotations.put(Fields.class, MappingModelMetadataProvider.createAnnotation(annotationDescriptor));
            this.createDateBridge(property);
            this.createCalendarBridge(property);
            this.createDynamicBoost(property);
            this.createFieldBridge(property);
        }

        private void addAnalyzerAnnotationTo(AnnotationDescriptor fieldAnnotation, Map.Entry<String, Object> entry) {
            AnnotationDescriptor analyzerAnnotation = new AnnotationDescriptor(Analyzer.class);
            Map analyzer = (Map)entry.getValue();
            for (Map.Entry analyzerEntry : analyzer.entrySet()) {
                analyzerAnnotation.setValue((String)analyzerEntry.getKey(), analyzerEntry.getValue());
            }
            fieldAnnotation.setValue("analyzer", (Object)MappingModelMetadataProvider.createAnnotation(analyzerAnnotation));
        }

        private void createFieldBridge(PropertyDescriptor property) {
            if (property.getFieldBridge() != null) {
                AnnotationDescriptor fieldBridgeAnn = new AnnotationDescriptor(FieldBridge.class);
                Set<Map.Entry<String, Object>> entrySet = property.getFieldBridge().entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    fieldBridgeAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(FieldBridge.class, MappingModelMetadataProvider.createAnnotation(fieldBridgeAnn));
            }
        }

        private void createDynamicBoost(PropertyDescriptor property) {
            if (property.getDynamicBoost() != null) {
                AnnotationDescriptor dynamicBoostAnn = new AnnotationDescriptor(DynamicBoost.class);
                Set<Map.Entry<String, Object>> entrySet = property.getDynamicBoost().entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    dynamicBoostAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(DynamicBoost.class, MappingModelMetadataProvider.createAnnotation(dynamicBoostAnn));
            }
        }

        private void createContainedIn(PropertyDescriptor property) {
            if (property.getContainedIn() != null) {
                Map<String, Object> containedIn = property.getContainedIn();
                AnnotationDescriptor containedInAnn = new AnnotationDescriptor(ContainedIn.class);
                Set<Map.Entry<String, Object>> entrySet = containedIn.entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    containedInAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(ContainedIn.class, MappingModelMetadataProvider.createAnnotation(containedInAnn));
            }
        }

        private void createIndexEmbedded(PropertyDescriptor property) {
            Map<String, Object> indexEmbedded = property.getIndexEmbedded();
            if (indexEmbedded != null) {
                AnnotationDescriptor indexEmbeddedAnn = new AnnotationDescriptor(IndexedEmbedded.class);
                Set<Map.Entry<String, Object>> entrySet = indexEmbedded.entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    indexEmbeddedAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(IndexedEmbedded.class, MappingModelMetadataProvider.createAnnotation(indexEmbeddedAnn));
            }
        }

        private void createIndexed(EntityDescriptor entity) {
            AnnotationDescriptor annotation;
            Class<Indexed> annotationType = Indexed.class;
            AnnotationDescriptor annotation2 = new AnnotationDescriptor(annotationType);
            if (entity.getIndexed() != null) {
                for (Map.Entry<String, Object> entry : entity.getIndexed().entrySet()) {
                    annotation2.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(annotationType, MappingModelMetadataProvider.createAnnotation(annotation2));
            }
            if (entity.getBoost() != null) {
                annotation = new AnnotationDescriptor(Boost.class);
                for (Map.Entry entry : entity.getBoost().entrySet()) {
                    annotation.setValue((String)entry.getKey(), entry.getValue());
                }
                this.annotations.put(Boost.class, MappingModelMetadataProvider.createAnnotation(annotation));
            }
            if (entity.getAnalyzerDiscriminator() != null) {
                annotation = new AnnotationDescriptor(AnalyzerDiscriminator.class);
                for (Map.Entry entry : entity.getAnalyzerDiscriminator().entrySet()) {
                    annotation.setValue((String)entry.getKey(), entry.getValue());
                }
                this.annotations.put(AnalyzerDiscriminator.class, MappingModelMetadataProvider.createAnnotation(annotation));
            }
            if (entity.getFullTextFilterDefs().size() > 0) {
                AnnotationDescriptor fullTextFilterDefsAnnotation = new AnnotationDescriptor(FullTextFilterDefs.class);
                FullTextFilterDef[] fullTextFilterDefArray = MappingModelMetadataProvider.createFullTextFilterDefArray(entity.getFullTextFilterDefs());
                fullTextFilterDefsAnnotation.setValue("value", (Object)fullTextFilterDefArray);
                this.annotations.put(FullTextFilterDefs.class, MappingModelMetadataProvider.createAnnotation(fullTextFilterDefsAnnotation));
            }
            if (entity.getProvidedId() != null) {
                this.createProvidedId(entity);
            }
            if (entity.getClassBridgeDefs().size() > 0) {
                AnnotationDescriptor classBridgesAnn = new AnnotationDescriptor(ClassBridges.class);
                ClassBridge[] classBridesDefArray = this.createClassBridgesDefArray(entity.getClassBridgeDefs());
                classBridgesAnn.setValue("value", (Object)classBridesDefArray);
                this.annotations.put(ClassBridges.class, MappingModelMetadataProvider.createAnnotation(classBridgesAnn));
            }
            if (entity.getSpatials().size() > 0) {
                AnnotationDescriptor spatialsAnn = new AnnotationDescriptor(Spatials.class);
                Spatial[] spatialsArray = this.createSpatialsArray(entity.getSpatials());
                spatialsAnn.setValue("value", (Object)spatialsArray);
                this.annotations.put(Spatials.class, MappingModelMetadataProvider.createAnnotation(spatialsAnn));
            }
            if (entity.getDynamicBoost() != null) {
                AnnotationDescriptor dynamicBoostAnn = new AnnotationDescriptor(DynamicBoost.class);
                Set<Map.Entry<String, Object>> entrySet = entity.getDynamicBoost().entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    dynamicBoostAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put(DynamicBoost.class, MappingModelMetadataProvider.createAnnotation(dynamicBoostAnn));
            }
            this.configureClassBridgeInstances(entity);
        }

        private ClassBridge[] createClassBridgesDefArray(Set<Map<String, Object>> classBridgeDefs) {
            ClassBridge[] classBridgeDefArray = new ClassBridge[classBridgeDefs.size()];
            int index = 0;
            for (Map<String, Object> classBridgeDef : classBridgeDefs) {
                classBridgeDefArray[index] = this.createClassBridge(classBridgeDef);
                ++index;
            }
            return classBridgeDefArray;
        }

        private void configureClassBridgeInstances(EntityDescriptor entity) {
            Map<org.hibernate.search.bridge.FieldBridge, Map<String, Object>> classBridges = entity.getClassBridgeInstanceDefs();
            for (Map.Entry<org.hibernate.search.bridge.FieldBridge, Map<String, Object>> classBridgeInstanceDef : classBridges.entrySet()) {
                Map<String, Object> configuration = classBridgeInstanceDef.getValue();
                org.hibernate.search.bridge.FieldBridge instance = classBridgeInstanceDef.getKey();
                ClassBridge classBridgeAnnotation = this.createClassBridge(configuration);
                entity.addClassBridgeInstanceConfiguration(instance, classBridgeAnnotation);
            }
        }

        private Spatial[] createSpatialsArray(Set<Map<String, Object>> spatials) {
            Spatial[] spatialsArray = new Spatial[spatials.size()];
            int index = 0;
            for (Map<String, Object> spatial : spatials) {
                spatialsArray[index] = this.createSpatial(spatial);
                ++index;
            }
            return spatialsArray;
        }

        private ClassBridge createClassBridge(Map<String, Object> classBridgeDef) {
            AnnotationDescriptor annotation = new AnnotationDescriptor(ClassBridge.class);
            Set<Map.Entry<String, Object>> entrySet = classBridgeDef.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                if ("analyzer".equals(entry.getKey())) {
                    this.addAnalyzerAnnotationTo(annotation, entry);
                    continue;
                }
                if ("params".equals(entry.getKey())) {
                    MappingModelMetadataProvider.addParamsToAnnotation(annotation, entry);
                    continue;
                }
                annotation.setValue(entry.getKey(), entry.getValue());
            }
            return (ClassBridge)MappingModelMetadataProvider.createAnnotation(annotation);
        }

        private Spatial createSpatial(Map<String, Object> spatial) {
            AnnotationDescriptor annotation = new AnnotationDescriptor(Spatial.class);
            Set<Map.Entry<String, Object>> entrySet = spatial.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                annotation.setValue(entry.getKey(), entry.getValue());
            }
            return (Spatial)MappingModelMetadataProvider.createAnnotation(annotation);
        }

        private void createProvidedId(EntityDescriptor entity) {
            AnnotationDescriptor annotation = new AnnotationDescriptor(ProvidedId.class);
            Set<Map.Entry<String, Object>> entrySet = entity.getProvidedId().entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                if ("bridge".equals(entry.getKey())) {
                    AnnotationDescriptor bridgeAnnotation = new AnnotationDescriptor(FieldBridge.class);
                    Map bridge = (Map)entry.getValue();
                    for (Map.Entry bridgeEntry : bridge.entrySet()) {
                        if ("params".equals(bridgeEntry.getKey())) {
                            MappingModelMetadataProvider.addParamsToAnnotation(bridgeAnnotation, bridgeEntry);
                            continue;
                        }
                        bridgeAnnotation.setValue((String)bridgeEntry.getKey(), bridgeEntry.getValue());
                    }
                    annotation.setValue("bridge", (Object)MappingModelMetadataProvider.createAnnotation(bridgeAnnotation));
                    continue;
                }
                annotation.setValue(entry.getKey(), entry.getValue());
            }
            this.annotations.put(ProvidedId.class, MappingModelMetadataProvider.createAnnotation(annotation));
        }

        private void populateAnnotationArray() {
            this.annotationsArray = new Annotation[this.annotations.size()];
            int index = 0;
            Iterator<Annotation> iterator = this.annotations.values().iterator();
            while (iterator.hasNext()) {
                Annotation ann;
                this.annotationsArray[index] = ann = iterator.next();
                ++index;
            }
        }

        private void delegatesAnnotationReading() {
            for (Annotation a : this.delegate.getAnnotations()) {
                this.annotations.put(a.annotationType(), a);
            }
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            this.initAnnotations();
            return (T)this.annotations.get(annotationType);
        }

        public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
            this.initAnnotations();
            return this.annotations.get(annotationType) != null;
        }

        public Annotation[] getAnnotations() {
            this.initAnnotations();
            Collection<Annotation> tmpCollection = this.annotations.values();
            return tmpCollection.toArray(new Annotation[tmpCollection.size()]);
        }
    }
}

