/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.modules.JDKSpecific;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Resource;
import org.jboss.modules.URLResource;

final class ClassLoaderLocalLoader
implements LocalLoader {
    static final LocalLoader SYSTEM = JDKSpecific.getSystemLocalLoader();
    private final ClassLoader classLoader;

    ClassLoaderLocalLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> loadClassLocal(String name, boolean resolve) {
        try {
            return Class.forName(name, resolve, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            return null;
        }
    }

    @Override
    public Package loadPackageLocal(String name) {
        return JDKSpecific.getPackage(this.classLoader, name);
    }

    @Override
    public List<Resource> loadResourceLocal(String name) {
        Enumeration<URL> urls;
        ClassLoader classLoader = this.classLoader;
        try {
            urls = classLoader == null ? JDKSpecific.getSystemResources(name) : classLoader.getResources(name);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<Resource> list = new ArrayList<Resource>();
        while (urls.hasMoreElements()) {
            list.add(new URLResource(urls.nextElement()));
        }
        return list;
    }
}

