/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import java.net.URI;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.naming.client.CurrentNamingProvider;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.PeerIdentity;

public interface NamingProvider
extends AutoCloseable {
    public List<Location> getLocations();

    @Deprecated
    default public URI getProviderUri() {
        return this.getLocations().get(0).getUri();
    }

    default public PeerIdentity getPeerIdentityForNaming() throws NamingException {
        List<Location> locations = this.getLocations();
        return this.getPeerIdentityForNaming(locations.get(ThreadLocalRandom.current().nextInt(locations.size())));
    }

    public PeerIdentity getPeerIdentityForNaming(Location var1) throws NamingException;

    @Deprecated
    default public AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.getLocations().get(0).getAuthenticationConfiguration();
    }

    @Deprecated
    default public SSLContext getSSLContext() {
        return this.getLocations().get(0).getSSLContext();
    }

    public static NamingProvider getCurrentNamingProvider() {
        return CurrentNamingProvider.getCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, U, R> R performAction(BiFunction<T, U, R> function, T arg1, U arg2) {
        NamingProvider old = CurrentNamingProvider.getAndSetCurrent(this);
        try {
            R r = function.apply(arg1, arg2);
            return r;
        }
        finally {
            CurrentNamingProvider.setCurrent(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, U, R, E extends Exception> R performExceptionAction(ExceptionBiFunction<T, U, R, E> function, T arg1, U arg2) throws E {
        NamingProvider old = CurrentNamingProvider.getAndSetCurrent(this);
        try {
            R r = function.apply(arg1, arg2);
            return r;
        }
        finally {
            CurrentNamingProvider.setCurrent(old);
        }
    }

    @Override
    default public void close() throws NamingException {
    }

    public static final class Location {
        private final URI uri;
        private final AuthenticationConfiguration authenticationConfiguration;
        private final SSLContext sslContext;

        Location(URI uri, AuthenticationConfiguration authenticationConfiguration, SSLContext sslContext) {
            Assert.checkNotNullParam("uri", uri);
            this.uri = uri;
            this.authenticationConfiguration = authenticationConfiguration;
            this.sslContext = sslContext;
        }

        public URI getUri() {
            return this.uri;
        }

        public AuthenticationConfiguration getAuthenticationConfiguration() {
            return this.authenticationConfiguration;
        }

        public SSLContext getSSLContext() {
            return this.sslContext;
        }

        public static Location of(URI uri) {
            return new Location(uri, null, null);
        }

        public static Location of(URI uri, AuthenticationConfiguration authenticationConfiguration, SSLContext sslContext) {
            return new Location(uri, authenticationConfiguration, sslContext);
        }
    }
}

