/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.ServerMessage;

public class LargeMessageTXFailureCallback
implements TransactionFailureCallback {
    private AbstractJournalStorageManager journalStorageManager;
    private final Map<Long, ServerMessage> messages;

    public LargeMessageTXFailureCallback(AbstractJournalStorageManager journalStorageManager, Map<Long, ServerMessage> messages) {
        this.journalStorageManager = journalStorageManager;
        this.messages = messages;
    }

    public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        for (RecordInfo record : records) {
            if (record.userRecordType != 30) continue;
            byte[] data = record.data;
            ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])data);
            try {
                LargeServerMessage serverMessage = this.journalStorageManager.parseLargeMessage(this.messages, buff);
                serverMessage.decrementDelayDeletionCount();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.journalError(e);
            }
        }
    }
}

