%global rolename image-template
%global roleprefix ovirt.
%global roleprefix_legacy ovirt-
%global roleprefix_legacy_uppercase oVirt.
%global ansible_roles_dir ansible/roles

Name: ovirt-ansible-image-template
Summary: Ansible role to create virtual machine template from disk image
Version: 1.1.9
Release: 1%{?release_suffix}%{?dist}
Source0: http://resources.ovirt.org/pub/src/ovirt-ansible-image-template/ovirt-ansible-image-template-1.1.9.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.7.2

%description
This Ansible role provide funtionality to create virtual machine template from disk
image.

%pretrans -p <lua>
-- Remove the legacy directory before installing the symlink. This is known issue in RPM:
-- https://fedoraproject.org/wiki/Packaging:Directory_Replacement
path_dash = "%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}"
path_uppercase = "%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}"

st = posix.stat(path_dash)
if st and st.type == "directory" then
  os.execute('rm -rf "'..path_dash..'"')
end

st = posix.stat(path_uppercase)
if st and st.type == "directory" then
  os.execute('rm -rf "'..path_uppercase..'"')
end

%prep
%setup -c -q

%build

%install
export PKG_DATA_DIR_ORIG=%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
export PKG_DATA_DIR=%{buildroot}$PKG_DATA_DIR_ORIG
export PKG_DOC_DIR=%{buildroot}%{_pkgdocdir}
export ROLENAME_LEGACY=%{buildroot}%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}
export ROLENAME_LEGACY_UPPERCASE=%{buildroot}%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}
sh build.sh install

%files
%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}
%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}

%doc README.md
%doc examples/

%license LICENSE

%changelog
* Thu Nov 29 2018 Ondra Machacek <omachace@redhat.com> - 1.1.9-1
- Support ovirt.image-template name.
- Require Ansible 2.7.2.

* Tue Sep 18 2018 Ondra Machacek <omachace@redhat.com> - 1.1.8-1
- Allow execute ansible on vm before template. gh#25
- Add parameter io_threads for template. gh#23
- Document that dry mode is unsupported. gh#22
- Support to pass hostname as well as URL. gh#21
- Support AWX credentials. gh#18

* Thu May 31 2018 Ondra Machacek <omachace@redhat.com> - 1.1.7-1
- Support to upload same template name to different datacenters.
- Add checking mandatory variables logic.
- Add parameters for os and memory.

* Tue Apr 10 2018 Ondra Machacek <omachace@redhat.com> - 1.1.6-1
- Require Ansible 2.5.

* Wed Jan 17 2018 Ondra Machacek <omachace@redhat.com> - 1.1.5-1
- Support RHV credentials for Ansible Tower/AWX.

* Tue Dec 12 2017 Ondra Machacek <omachace@redhat.com> - 1.1.4-1
- Package missing vars/ directory.

* Mon Dec 04 2017 Ondra Machacek <omachace@redhat.com> - 1.1.3-1
- Add %pretrans scriplet to remove legacy role name.

* Wed Nov 29 2017 Ondra Machacek <omachace@redhat.com> - 1.1.2-1
- Rename prefix ovirt. to oVirt. to sync with galaxy

* Mon Nov 27 2017 Ondra Machacek <omachace@redhat.com> - 1.1.0-1
- Initial release
