/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.Boolean;
import java.lang.String;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.MacPoolContainer;
import org.ovirt.engine.sdk4.types.MacPool;
import org.ovirt.engine.sdk4.types.Range;

public class MacPoolBuilder {
    private Boolean allowDuplicates;
    private String comment;
    private Boolean defaultPool;
    private String description;
    private String href;
    private String id;
    private String name;
    private List<Range> ranges;
    
    public MacPoolBuilder allowDuplicates(boolean newAllowDuplicates) {
        allowDuplicates = Boolean.valueOf(newAllowDuplicates);
        return this;
    }
    
    public MacPoolBuilder allowDuplicates(Boolean newAllowDuplicates) {
        allowDuplicates = newAllowDuplicates;
        return this;
    }
    
    
    public MacPoolBuilder comment(String newComment) {
        comment = newComment;
        return this;
    }
    
    
    public MacPoolBuilder defaultPool(boolean newDefaultPool) {
        defaultPool = Boolean.valueOf(newDefaultPool);
        return this;
    }
    
    public MacPoolBuilder defaultPool(Boolean newDefaultPool) {
        defaultPool = newDefaultPool;
        return this;
    }
    
    
    public MacPoolBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public MacPoolBuilder href(String newHref) {
        href = newHref;
        return this;
    }
    
    
    public MacPoolBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public MacPoolBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public MacPoolBuilder ranges(List<Range> newRanges) {
        if (newRanges != null) {
            if (ranges == null) {
                ranges = new ArrayList<>(newRanges);
            }
            else {
                ranges.addAll(newRanges);
            }
        }
        return this;
    }
    
    public MacPoolBuilder ranges(Range... newRanges) {
        if (newRanges != null) {
            if (ranges == null) {
                ranges = new ArrayList<>(newRanges.length);
            }
            Collections.addAll(ranges, newRanges);
        }
        return this;
    }
    
    public MacPoolBuilder ranges(RangeBuilder... newRanges) {
        if (newRanges != null) {
            if (ranges == null) {
                ranges = new ArrayList<>(newRanges.length);
            }
            for (RangeBuilder builder : newRanges) {
                ranges.add(builder.build());
            }
        }
        return this;
    }
    
    
    public MacPool build() {
        MacPoolContainer container = new MacPoolContainer();
        container.allowDuplicates(allowDuplicates);
        container.comment(comment);
        container.defaultPool(defaultPool);
        container.description(description);
        container.href(href);
        container.id(id);
        container.name(name);
        container.ranges(ranges);
        return container;
    }
}
